package com.example.terminalprotocol;

import java.io.UnsupportedEncodingException;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.text.method.ScrollingMovementMethod;
import android.util.Base64;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.sdses.JniCommonInterface;

public class Card extends Activity {
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.card);
	}
	private ImageView photoImageView;
	
	public void btn_readcard(View v)
	{
		TextView NameText=(TextView)findViewById(R.id.tv_nameo);
		TextView SexText=(TextView)findViewById(R.id.tv_sexo);
		TextView NationText=(TextView)findViewById(R.id.tv_nationo);
		TextView BirhText=(TextView)findViewById(R.id.tv_birtho);
		TextView AddrText=(TextView)findViewById(R.id.tv_addro);
		TextView IdNumText=(TextView)findViewById(R.id.tv_idnumo);
		TextView SignText=(TextView)findViewById(R.id.tv_signo);
		TextView BeginText=(TextView)findViewById(R.id.tv_begino);
		TextView EndText=(TextView)findViewById(R.id.tv_endo);
		TextView NameENText=(TextView)findViewById(R.id.tv_nameEno);
		TextView VersionText=(TextView)findViewById(R.id.tv_versiono);
		TextView TypeText=(TextView)findViewById(R.id.tv_typeo);
		TextView CardFPText=(TextView)findViewById(R.id.tv_CardFP);
		CardFPText.setMovementMethod(ScrollingMovementMethod.getInstance());
		photoImageView=(ImageView)findViewById(R.id.imageView1);
		
	/*
	byte[] Name=new byte[1024];
	byte[] NameEN=new byte[1024];
	byte[] Gender=new byte[1024];
	byte[] GenderId=new byte[1024];
	byte[] Nation=new byte[1024];
	byte[] NationId=new byte[1024];
	byte[] BirthDate=new byte[1024];
	byte[] Address=new byte[1024];
	byte[] IdNumber=new byte[1024];
	byte[] SignOrgan=new byte[1024];
	byte[] BeginTerm=new byte[1024];
	byte[] ValidTerm=new byte[1024];
	byte[] NewAddress=new byte[1024];
	byte[] FPBuffer=new byte[2048];
	long[] FPBufferLen=new long[1];
	*/
	String PhotoFile="C:\\Users\\test\\Desktop\\Photo.bmp";
	byte WltBmpJpg=1;
	byte[] PhotoBuffer=new byte[102400];
	long[] PhotoBufferLen=new long[1];
	//第一个参数Type可为0（二代证、外国人都读）、1（只读二代证）、2（只读外国人）、3（港澳台）
	//第二个参数编码方式1（GBK）、2（Unicode16-LE）
	//第四个参数TimeOutMs：等待读卡时间，超过该时间，读卡失败（单位ms）
	byte Type=0x10;
	byte InfoEncoding=1;
	long TimeOutMs=0;
	byte[] IdCardInfo=new byte[40960];
	long res=JniCommonInterface.IdReadCard(Type,InfoEncoding,IdCardInfo,TimeOutMs);
	if(res!=0)
	{
		Toast.makeText(this, "读卡失败，错误代码："+res, 0).show();
		return;
	}
	Toast.makeText(this, "读卡成功", 0).show();
	//long l=JniCommonInterface.IdCardGetPhotoFile(PhotoFile);
	//long r=JniCommonInterface.IdCardGetPhotoBuffer(WltBmpJpg, PhotoBuffer, PhotoBufferLen);
	try {
		String s=new String(IdCardInfo,"GBK").trim();
		String[] IdInfoStr=s.split(":",16);
		TypeText.setText(IdInfoStr[0]);
		NameText.setText(IdInfoStr[1]);
		NameENText.setText(IdInfoStr[2]);
		SexText.setText(IdInfoStr[3]);
		NationText.setText(IdInfoStr[5]);
		BirhText.setText(IdInfoStr[7]);
		AddrText.setText(IdInfoStr[8]);
		IdNumText.setText(IdInfoStr[9]);
		SignText.setText(IdInfoStr[10]);
		BeginText.setText(IdInfoStr[11]);
		EndText.setText(IdInfoStr[12]);
		VersionText.setText(IdInfoStr[13]);
		if(IdInfoStr[14]!="")
		{
			byte[] imgbytes = Base64.decode(IdInfoStr[14], Base64.DEFAULT);
			Bitmap bm = BitmapFactory.decodeByteArray(imgbytes, 0, imgbytes.length);
			if(bm!=null)
			{
				photoImageView.setImageBitmap(bm);
			}
		}	
		if(IdInfoStr[15].length()!=0)
		{
			CardFPText.setText("指纹特征值："+IdInfoStr[15]+"\n");
		}	
	} catch (UnsupportedEncodingException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
	}
	//采集特征值1
	String strBase64FP1;
	byte[] Feature1=new byte[512];
	long[] FeatureLen1=new long[2];
	public void btn_FpCapFeature1(View v) 
	{
		EditText FP1Text=(EditText)findViewById(R.id.et_FP1);
//		FP1Text.setMovementMethod(ScrollingMovementMethod.getInstance());
		long res=JniCommonInterface.FpCapFeature(Feature1, FeatureLen1);
		if(res!=0)
		{
			Toast.makeText(this, "采集指纹特征值1失败，错误代码："+res, 0).show();
			return;
		}
//		Toast.makeText(this, "采集指纹特征值1成功", 0).show();		
		strBase64FP1 = Base64.encodeToString(Feature1, Base64.DEFAULT);  
		FP1Text.setText(strBase64FP1);
	}
	//采集特征值2
	String strBase64FP2;
	byte[] Feature2=new byte[512];
	long[] FeatureLen2=new long[2];
	public void btn_FpCapFeature2(View v)
	{
		EditText FP2Text=(EditText)findViewById(R.id.et_FP2);
//		FP2Text.setMovementMethod(ScrollingMovementMethod.getInstance());
		long res=JniCommonInterface.FpCapFeature(Feature2, FeatureLen2);
		if(res!=0)
		{
			Toast.makeText(this, "采集指纹特征值2失败，错误代码："+res, 0).show();
			return;
		}
//		Toast.makeText(this, "采集指纹特征值2成功", 0).show();
		strBase64FP2 = Base64.encodeToString(Feature2, Base64.DEFAULT);  
		FP2Text.setText(strBase64FP2);
	}
	//特征值比对
	public void btn_FpMatchFeature(View v)
	{
		EditText FPScoreText=(EditText)findViewById(R.id.et_FPScore);
//		FPScoreText.setMovementMethod(ScrollingMovementMethod.getInstance());
		long[] Score=new long[2];
		long res=JniCommonInterface.FpMatchFeature(FeatureLen1[0], Feature1, FeatureLen2[0], Feature2, Score);
		if(res!=0)
		{
			Toast.makeText(this, "指纹特征值比对失败，错误代码："+res, 0).show();
			return;
		}
		//Toast.makeText(this, "指纹特征值比对成功", 0).show();
		FPScoreText.setText("指纹比对分数："+Score[0]);		
	}	
	public void btn_SDTreadcard(View v)
	{
		TextView NameText=(TextView)findViewById(R.id.tv_nameo);
		TextView SexText=(TextView)findViewById(R.id.tv_sexo);
		TextView NationText=(TextView)findViewById(R.id.tv_nationo);
		TextView BirhText=(TextView)findViewById(R.id.tv_birtho);
		TextView AddrText=(TextView)findViewById(R.id.tv_addro);
		TextView IdNumText=(TextView)findViewById(R.id.tv_idnumo);
		TextView SignText=(TextView)findViewById(R.id.tv_signo);
		TextView BeginText=(TextView)findViewById(R.id.tv_begino);
		TextView EndText=(TextView)findViewById(R.id.tv_endo);
		TextView NameENText=(TextView)findViewById(R.id.tv_nameEno);
		TextView VersionText=(TextView)findViewById(R.id.tv_versiono);
		TextView TypeText=(TextView)findViewById(R.id.tv_typeo);
		TextView CardFPText=(TextView)findViewById(R.id.tv_CardFP);
		CardFPText.setMovementMethod(ScrollingMovementMethod.getInstance());
		photoImageView=(ImageView)findViewById(R.id.imageView1);
		
		byte Type=0x10;
		byte InfoEncoding=1;
		long TimeOutMs=0;
		byte[] IdCardInfo=new byte[40960];
		long res=JniCommonInterface.SdtReadCard(Type,InfoEncoding,IdCardInfo,TimeOutMs);
		if(res!=0)
		{
			Toast.makeText(this, "读卡失败，错误代码："+res, 0).show();
			return;
		}
		Toast.makeText(this, "读卡成功", 0).show();
		try {
			String s=new String(IdCardInfo,"GBK").trim();
			String[] IdInfoStr=s.split(":",16);
			TypeText.setText(IdInfoStr[0]);
			NameText.setText(IdInfoStr[1]);
			NameENText.setText(IdInfoStr[2]);
			SexText.setText(IdInfoStr[3]);
			NationText.setText(IdInfoStr[5]);
			BirhText.setText(IdInfoStr[7]);
			AddrText.setText(IdInfoStr[8]);
			IdNumText.setText(IdInfoStr[9]);
			SignText.setText(IdInfoStr[10]);
			BeginText.setText(IdInfoStr[11]);
			EndText.setText(IdInfoStr[12]);
			VersionText.setText(IdInfoStr[13]);
			if(IdInfoStr[14]!="")
			{
				byte[] imgbytes = Base64.decode(IdInfoStr[14], Base64.DEFAULT);
				Bitmap bm = BitmapFactory.decodeByteArray(imgbytes, 0, imgbytes.length);
				if(bm!=null)
				{
					photoImageView.setImageBitmap(bm);
				}
			}	
			if(IdInfoStr[15].length()!=0)
			{
				CardFPText.setText("指纹特征值："+IdInfoStr[15]+"\n");
			}	
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}	
}
