package com.example.terminalprotocol;

import java.io.UnsupportedEncodingException;
import java.nio.LongBuffer;

import com.sdses.JniCommonInterface;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;

public class Cpu extends Activity{	
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.cpu);
	}	
	
	public void btn_CpuPowerOn(View v)
	{
		byte[] slot=new byte[16];
		EditText slotText=(EditText)findViewById(R.id.et_slot);
		EditText resetEditText=(EditText)findViewById(R.id.et_reset);
		//byte slot=Byte.parseByte(slotText.getText().toString().trim());
		String slotStr=slotText.getText().toString().trim();
		if(slotStr.length()%2!=0)
		{
			Toast.makeText(this, "卡槽长度错误", 0).show();
			return;
		}		
		JniCommonInterface.AscToHex(slotStr, slotStr.length()/2, slot);
		byte[] ATRS=new byte[256];
		long[] ATRSLen=new long[1];
		long res=JniCommonInterface.CpuPowerOn(slot[0], ATRS, ATRSLen);
		if(res!=0)
		{
			Toast.makeText(this,"CPU卡上电失败，错误代码："+res, 0).show();
			return;
		}
		Toast.makeText(this, "卡上电成功", 0).show();
		byte[] ATRSAsc=new byte[512];
		JniCommonInterface.HexToAsc(ATRS, ATRSLen[0], ATRSAsc);
		try {
			resetEditText.setText(new String(ATRSAsc,"GBK"));
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	public void btn_Apdu(View v)
	{
		byte[] slot=new byte[16];
		EditText slotText=(EditText)findViewById(R.id.et_slot);
		String slotStr=slotText.getText().toString().trim();
		if(slotStr.length()%2!=0)
		{
			Toast.makeText(this, "卡槽长度错误", 0).show();
			return;
		}		
		JniCommonInterface.AscToHex(slotStr, slotStr.length()/2, slot);
		EditText SendApduText=(EditText)findViewById(R.id.et_send);
		EditText RecvApduText=(EditText)findViewById(R.id.et_resceive);
		byte[] RecvApdu=new byte[256];
		long[] RecvApduLen=new long[1];	
		String SendApduStr=SendApduText.getText().toString();	
		if(SendApduStr.length()==0)
		{
			Toast.makeText(this, "请输入发送数据！", 0).show();
			return;
		}
		if(SendApduStr.length() % 2 !=0)
		{
			Toast.makeText(this, "发送数据长度错误", 0).show();
			return;
		}
		byte[] SendApdu=new byte[256];
		JniCommonInterface.AscToHex(SendApduStr, SendApduStr.length()/2, SendApdu);
		//取8位随机数：0084000008
		long res=JniCommonInterface.CpuApdu(slot[0], SendApduStr.length()/2, SendApdu, RecvApdu, RecvApduLen);
		if(res!=0)
		{
			if(res==109||res==0x6D)
			{
				Toast.makeText(this, "不支持该指令",0).show();
				return;
			}
			Toast.makeText(this, "返回数据失败，错误代码："+res,0).show();
			return;
		}		
		Toast.makeText(this, "返回数据成功",0).show();
		byte[] RecvApduAsc=new byte[512];
		JniCommonInterface.HexToAsc(RecvApdu, RecvApduLen[0], RecvApduAsc);
		try {
			RecvApduText.setText(new String(RecvApduAsc,"GBK"));
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}	
	}
	public void btn_CpuPowerOff(View v)
	{
		byte[] slot=new byte[16];
		EditText slotText=(EditText)findViewById(R.id.et_slot);
		String slotStr=slotText.getText().toString().trim();
		if(slotStr.length()%2!=0)
		{
			Toast.makeText(this, "卡槽长度错误", 0).show();
			return;
		}		
		JniCommonInterface.AscToHex(slotStr, slotStr.length()/2, slot);
		long res=JniCommonInterface.CpuPowerOff(slot[0]);
		if(res!=0)
		{
			Toast.makeText(this,"卡片下电失败，错误代码："+res, 0).show();
			return;
		}
		Toast.makeText(this, "卡片下电成功", 0).show();
	}

}
