package com.example.terminalprotocol;

import java.io.UnsupportedEncodingException;
import java.security.PublicKey;

import com.sdses.JniCommonInterface;

import android.app.Activity;
import android.os.Bundle;
import android.support.v7.widget.PopupMenu;
import android.support.v7.widget.PopupMenu.OnMenuItemClickListener;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Spinner;
import android.widget.Toast;

public class M1 extends Activity implements OnClickListener {
	public EditText scanEditText;
	public ImageView aImageView;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.m1);
		scanEditText=(EditText)findViewById(R.id.et_scan);
		aImageView=(ImageView)findViewById(R.id.iv_value);
		aImageView.setOnClickListener(this);
	}
	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		PopupMenu pm=new PopupMenu(this, scanEditText);
		pm.getMenuInflater().inflate(R.menu.main, pm.getMenu());
		pm.setOnMenuItemClickListener(new OnMenuItemClickListener() {			
			@Override
			public boolean onMenuItemClick(MenuItem item) {
				// TODO Auto-generated method stub
				
				scanEditText.setText(item.getTitle());
				return false;
			}
		});
		pm.show();
	}
	byte[] uid=new byte[16];
	public void btn_FindM1(View v)
	{
		EditText uidEditText=(EditText)findViewById(R.id.et_uid);
		long[] uidLen=new long[1];
		long res=JniCommonInterface.M1FindCard(uid, uidLen);
		if(res!=0)
		{
			Toast.makeText(this, "寻卡失败，错误代码："+res, 0).show();
			return;
		}
		Toast.makeText(this, "寻卡成功", 0).show();
		byte[] uidAsc=new byte[32];
		JniCommonInterface.HexToAsc(uid, uidLen[0], uidAsc);	
		try {
			uidEditText.setText(new String(uidAsc,"GBK").trim());
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}		
	}
	public void btn_M1Auth(View v)
	{
		Spinner keyTypeSpinner=(Spinner)findViewById(R.id.sp_key);
		EditText scanEditText=(EditText)findViewById(R.id.et_scan);
		EditText keyEditText=(EditText)findViewById(R.id.et_key);
		//获取spinner当前选中项
		String keyTypeStr=keyTypeSpinner.getSelectedItem().toString();
		byte[] keybytes=keyTypeStr.getBytes();//可得到选中项中的某个字符
		byte KeyType=keybytes[3];
	    byte SecAddr=(byte)Integer.parseInt(scanEditText.getText().toString().trim());
	   // byte[] bt=scanEditText.getText().toString().trim().getBytes();
	    String keyStr=keyEditText.getText().toString().trim();
	    if(keyStr.length()!=12)
	    {
	    	Toast.makeText(this, "密钥长度错误", 0).show();
	    	return;
	    }
	    byte[] Key=new byte[12];
	    JniCommonInterface.AscToHex(keyStr, keyStr.length()/2, Key);
		long res=JniCommonInterface.M1Authentication(KeyType, SecAddr, Key, uid);
		if(res!=0)
		{
			Toast.makeText(this, "认证失败，错误代码："+res, 0).show();
			return;
		}
		Toast.makeText(this, "认证成功", 0).show();			
	}
	public void btn_M1ReadData(View v)
	{
		EditText BlockAddrEditText=(EditText)findViewById(R.id.et_rblock);
		EditText BlockDataEditText=(EditText)findViewById(R.id.et_rblockdata);
		byte BlockAddr=(byte)Integer.parseInt((BlockAddrEditText.getText().toString().trim()));
		byte[] BlockData=new byte[64];
		long[] BlockDataLen=new long[1];
		long res=JniCommonInterface.M1ReadBlock(BlockAddr, BlockData, BlockDataLen);
		if(res!=0)
		{
			Toast.makeText(this, "读卡失败，错误代码："+res, 0).show();
			return;
		}
		Toast.makeText(this, "读卡成功", 0).show();		
		try {
			byte[] BlockDataStr=new byte[32];
			JniCommonInterface.HexToAsc(BlockData, BlockDataLen[0], BlockDataStr);			
			BlockDataEditText.setText(new String(BlockDataStr,"GBK").trim());
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}	
	}
	public void btn_M1WriteData(View v)
	{
		EditText BlockAddrEditText=(EditText)findViewById(R.id.et_wblock);
		EditText BlockDataEditText=(EditText)findViewById(R.id.et_wblockdata);
		byte BlockAddr=(byte)Integer.parseInt((BlockAddrEditText.getText().toString().trim()));
		String blockDataStr=BlockDataEditText.getText().toString().trim();
	    if(blockDataStr.length()!=32)
		    {
		    	Toast.makeText(this, "块数据长度错误", 0).show();
		    	return;
		    }
		byte[] BlockData=new byte[64];
		long BlockDataLen=16;
		JniCommonInterface.AscToHex(blockDataStr, blockDataStr.length()/2, BlockData);
		long res=JniCommonInterface.M1WriteBlock(BlockAddr, BlockDataLen, BlockData);
		if(res!=0)
		{
			Toast.makeText(this, "写卡失败，错误代码："+res, 0).show();
			return;
		}
		Toast.makeText(this, "写卡成功", 0).show();					
	}
	

}
