package com.example.terminalprotocol;

import java.io.UnsupportedEncodingException;

import com.sdses.JniCommonInterface;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Toast;

public class Magnetic extends Activity{
	Spinner magnumsSpinner;
	EditText magouttimeEditText;
	EditText mag1EditText;
	EditText mag2EditText;
	EditText mag3EditText;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.magnetic);
		magnumsSpinner=(Spinner)findViewById(R.id.sp_magnum);
		magouttimeEditText=(EditText)findViewById(R.id.et_magtime);
		mag1EditText=(EditText)findViewById(R.id.et_mag1);
		mag2EditText=(EditText)findViewById(R.id.et_mag2);
		mag3EditText=(EditText)findViewById(R.id.et_mag3);
	}
	public void btn_readmagnetic(View v)
	{
		byte Tracks=(byte)Integer.parseInt(magnumsSpinner.getSelectedItem().toString().trim());
		byte[] TrackData1=new byte[1024];
		byte[] TrackData2=new byte[1024];
		byte[] TrackData3=new byte[1024];
		byte TimeOutSec=(byte)Integer.parseInt(magouttimeEditText.getText().toString().trim());
		long res=JniCommonInterface.MagRead(Tracks, TrackData1, TrackData2, TrackData3, TimeOutSec);
		if(res!=0)
		{
			Toast.makeText(this, "读取磁条卡失败，错误代码："+res, 0).show();
			return;
		}
		Toast.makeText(this, "读取磁条卡成功", 0).show();
		try {
			mag1EditText.setText(new String(TrackData1,"GBK"));
			mag2EditText.setText(new String(TrackData2,"GBK"));
			mag3EditText.setText(new String(TrackData3,"GBK"));
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void btn_writemagnetic(View v)
	{
		byte Tracks=(byte)Integer.parseInt(magnumsSpinner.getSelectedItem().toString().trim());
		byte TimeOutSec=(byte)Integer.parseInt(magouttimeEditText.getText().toString().trim());
		String TrackData1=mag1EditText.getText().toString().trim();
		String TrackData2=mag2EditText.getText().toString().trim();
		String TrackData3=mag3EditText.getText().toString().trim();			
		long res=JniCommonInterface.MagWrite(Tracks, TrackData1, TrackData2, TrackData3, TimeOutSec);
		if(res!=0)
		{
			Toast.makeText(this, "写入磁条卡失败，错误代码："+res, 0).show();
			return;
		}
		Toast.makeText(this, "写入磁条卡成功", 0).show();
	}

}
