package com.example.terminalprotocol;

import java.lang.reflect.Field;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.example.terminalprotocol.R;
import com.sdses.JniCommonInterface;

import android.R.integer;
import android.R.string;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.SimpleAdapter;
import android.widget.Toast;

public class SecondActivity extends Activity {
	private GridView gridView;
	private String[] from = { "image", "text" };
	private int[] to = { R.id.image, R.id.text};

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.second);
		gridView = (GridView) findViewById(R.id.gridView1);
		SimpleAdapter adapter = new SimpleAdapter(this, getList(),
				R.layout.picture_item, from, to);
		gridView.setAdapter(adapter);

		gridView.setOnItemClickListener(new OnItemClickListener() {
			@Override
			public void onItemClick(AdapterView<?> arg0, View arg1,
					int position, long id) {
				// TODO Auto-generated method stub
				switch (position) {
				case 0:
					Intent i = new Intent(getApplicationContext(), Card.class);
					startActivity(i);
					break;
				case 1:
					Intent i1 = new Intent(getApplicationContext(), Bank.class);
					startActivity(i1);
					break;
				case 2:
					Intent i2 = new Intent(getApplicationContext(),
							SocialSecurity.class);
					startActivity(i2);
					break;
				case 3:
					Intent i3 = new Intent(getApplicationContext(), M1.class);
					startActivity(i3);
					break;
				case 4:
					Intent i4 = new Intent(getApplicationContext(), Magnetic.class);
					startActivity(i4);
					break;
				case 5:
					Intent i5 = new Intent(getApplicationContext(), Cpu.class);
					startActivity(i5);
					break;
				case 6:
					Intent i6 = new Intent(getApplicationContext(), test.class);
					startActivity(i6);
					break;

				default:
					break;
				}
			}
		});

	}

	public List<? extends Map<String, ?>> getList() {
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
		Map<String, Object> map = null;
		int[] images = { R.drawable.card, R.drawable.bank, R.drawable.si,
				R.drawable.e, R.drawable.ctk,R.drawable.cpu, R.drawable.f};
		String[] texts = new String[] { "二代证", "银行卡", "社保卡", "M1卡", "磁条卡","CPU卡",
				"内部测试" };
		for (int i = 0; i < images.length; i++) {
			map = new HashMap<String, Object>();
			map.put("image", images[i]);
			map.put("text", texts[i]);
			list.add(map);
		}
		return list;
	}
@Override
public void onBackPressed() {
	// TODO Auto-generated method stub
	super.onBackPressed();
	long res=JniCommonInterface.CloseDevice();
	if(res!=0)
	{
		Toast.makeText(this, "关闭设备失败，错误代码："+res, 0).show();
		return;
	}
	Toast.makeText(this, "关闭设备成功，返回初始界面", 0).show();
	setContentView(R.layout.activity_main);	
}
}
