package com.example.terminalprotocol;

import java.io.UnsupportedEncodingException;

import com.sdses.JniCommonInterface;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;

public class SocialSecurity extends Activity {
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.socialsecurity);
	}
	public void btn_readSocial(View v)
	{
		EditText CardNumber=(EditText)findViewById(R.id.et_scard); //卡号
		EditText CardType=(EditText)findViewById(R.id.et_scardType); //卡类别
		EditText CardVersion=(EditText)findViewById(R.id.et_sversion); //规范版本
		EditText CardBegin=(EditText)findViewById(R.id.et_sbegin); //发卡日期
		EditText CardEnd=(EditText)findViewById(R.id.et_sEnd); //有效期限
		EditText CardInicode=(EditText)findViewById(R.id.et_sInicode); //初始化机构编码
		EditText CardID=(EditText)findViewById(R.id.et_sCardID); //卡识别码
		EditText ID=(EditText)findViewById(R.id.et_sidnum); //身份证号
		EditText Name=(EditText)findViewById(R.id.et_sName); //姓名
		EditText Sex=(EditText)findViewById(R.id.et_sSex); //性别
		EditText Nation=(EditText)findViewById(R.id.et_sNation); //民族
		EditText Addr=(EditText)findViewById(R.id.et_sAddr); //出生地址
		EditText Birth=(EditText)findViewById(R.id.et_sBirth); //出生日期
		
		//iType 1:接触卡   2非接卡  3先接触后非接  4先非接后接触
		int iType=3;
		byte[] SSCardInfo=new byte[2048];//社保卡长度大小：2048，共14项数据,通过：分割
		byte[] ErrorInfo=new byte[1024];		
		long res=JniCommonInterface.SsseReadCard(iType, SSCardInfo, ErrorInfo);
		if(res!=0)
		{
			String errorStr;
			try {
				errorStr = new String(ErrorInfo,"GBK");
				Toast.makeText(this, "读取社保卡失败，错误代码："+res+" "+errorStr, 0).show();
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			return;
		}
		Toast.makeText(this, "读取社保卡成功", 0).show();
		try {
			String s=new String(SSCardInfo,"GBK").trim();
			String[] SCardInfoStr=s.split(":", 14);
			CardNumber.setText(SCardInfoStr[6]);
			CardType.setText(SCardInfoStr[1]);
			CardVersion.setText(SCardInfoStr[2]);
			CardBegin.setText(SCardInfoStr[4]);
			CardEnd.setText(SCardInfoStr[5]);
			CardInicode.setText(SCardInfoStr[3]);
			CardID.setText(SCardInfoStr[0]);
			ID.setText(SCardInfoStr[7]);
			Name.setText(SCardInfoStr[8]);
			Sex.setText(SCardInfoStr[10]);
			Nation.setText(SCardInfoStr[11]);
			Addr.setText(SCardInfoStr[12]);
			Birth.setText(SCardInfoStr[13]);
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}	
}
