import java.io.UnsupportedEncodingException;

//import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.win32.StdCallLibrary;
import java.util.Scanner;

public class JnaTest {
	public interface CommonInterface extends StdCallLibrary {
		CommonInterface instance = (CommonInterface) Native.loadLibrary("CommonInterface", CommonInterface.class);
//		int OpenDevice(String PortType, String PortPara, String ExtendPara);
//		int CloseDevice();
//		int IdReadCard(byte CardType, byte InfoEncoding, byte[] IdCardInfo, int TimeOutMs);
//		int IccGetCardInfo(int ICtype, String AIDList, String TagList, byte[] IcCardInfo);
//		int SsseReadCard(int iType, byte[] SSCardInfo, byte[] SSErrorInfo);
//		int M1FindCard(byte[] UID, int[] UIDLen);
		
		int SetTerminalLibrary(String LibraryFileName);
		int SetAutoPara(String PortType, String PortPara, String ExtendPara);
		int OpenDevice(String PortType, String PortPara, String ExtendPara);
		int SetCurrentDevice(int DevHandle);
		int GetCurrentDevice();
		int CloseDevice();
		int TerminalGetModel(byte[] TerminalModel);
		int TerminalGetFirmVersion(byte[] FirmVersion, byte[] HardwareVersion);
		int TerminalHeartBeat();
		int GetLastRecvData(byte[] LastRecvData);

		int IdFindCard();
		int IdSelectCard();
		int IdReadBaseMsg(byte[] pucCHMsg, int[] puiCHMsgLen, byte[] pucPHMsg, int[] puiPHMsgLen);
		int IdReadBaseFpMsg(byte[] pucCHMsg, int[] puiCHMsgLen, byte[] pucPHMsg, int[] puiPHMsgLen, byte[] pucFPMsg, int[] puiFPMsgLen);
		int IdReadNewAppMsg(byte[] pucAppMsg, int[] puiAppMsgLen);
		int IdReadSn(byte[] SN, int[] SNLen);
		int IdApdu(int SendApduLen, byte[] SendApdu, byte[] RecvApdu, int[] RecvApduLen);
		int SdtFindCard(byte[] pucManaInfo);
		int SdtSelectCard(byte[] pucManaMsg);
		int SdtReadBaseMsg(byte[] pucCHMsg, int[] puiCHMsgLen, byte[] pucPHMsg, int[] puiPHMsgLen);
		int SdtReadBaseFpMsg(byte[] pucCHMsg, int[] puiCHMsgLen, byte[] pucPHMsg, int[] puiPHMsgLen, byte[] pucFPMsg, int[] puiFPMsgLen);
		int SdtReadNewAppMsg(byte[] pucAppMsg, int[] puiAppMsgLen);
		int SamGetStatus();
		int SamGetId(byte[] SamId, int[] SamIdLen);
		int SamGetIdStr(byte[] SamIdStr);
		int SdtSamGetStatus();
		int SdtSamGetId(byte[] SamId, int[] SamIdLen);
		int SdtSamGetIdStr(byte[] SamIdStr);

		int IdReadCard(byte CardType, byte InfoEncoding, byte[] IdCardInfo, int TimeOutMs);
		int SdtReadCard(byte CardType, byte InfoEncoding, byte[] IdCardInfo, int TimeOutMs);
		int IdReadNewAddress(byte[] NewAddress);
		int SdtReadNewAddress(byte[] NewAddress);
		int IdCardGetRawInfo(byte[] CHMsg, int[] CHMsgLen, byte[] PHMsg, int[] PHMsgLen, byte[] FPMsg, int[] FPMsgLen);
		int IdCardGetName(byte[] Name);
		int IdCardGetNameEn(byte[] NameEn);
		int IdCardGetGender(byte[] Gender);
		int IdCardGetGenderId(byte[] GenderId);
		int IdCardGetNation(byte[] Nation);
		int IdCardGetNationId(byte[] NationId);
		int IdCardGetBirthDate(byte[] BirthDate);
		int IdCardGetAddress(byte[] Address);
		int IdCardGetIdNumber(byte[] IdNumber);
		int IdCardGetSignOrgan(byte[] SignOrgan);
		int IdCardGetBeginTerm(byte[] BeginTerm);
		int IdCardGetValidTerm(byte[] ValidTerm);
		int IdCardGetTypeFlag(byte[] TypeFlag);
		int IdCardGetVersion(byte[] Version);
		int IdCardGetFPBuffer(byte[] FPBuffer, int[] FPBufferLen);
		int IdCardGetPhotoFile(String PhotoFile);
		int IdCardGetPhotoBuffer(byte WltBmpJpg, byte[] PhotoBuffer, int[] PhotoBufferLen);

		int MagRead(byte Tracks, byte[] TrackData1, byte[] TrackData2, byte[] TrackData3, byte TimeOutSec);
		int MagWrite(byte Tracks, String TrackData1, String TrackData2, String TrackData3, byte TimeOutSec);

		int QrRead(byte[] QrData, byte TimeOutSec);

		int CpuPowerOn(byte Slot, byte[] ATRS, int[] ATRSLen);
		int CpuApdu(byte Slot, int SendApduLen, byte[] SendApdu, byte[] RecvApdu, int[] RecvApduLen);
		int CpuPowerOff(byte Slot);

		int M1FindCard(byte[] UID, int[] UIDLen);
		int M1Authentication(byte KeyType, byte SecAddr, byte[] Key, byte[] UID);
		int M1ReadBlock(byte BlockAddr, byte[] BlockData, int[] BlockDataLen);
		int M1WriteBlock(byte BlockAddr, int BlockDataLen, byte[] BlockData);
		int M1Halt();

		int M0FindCard(byte[] UID, int[] UIDLen);
		int M0Authentication(byte[] Key);
		int M0ReadBlock(byte BlockAddr, byte[] BlockData, int[] BlockDataLen);
		int M0WriteBlock(byte BlockAddr, int BlockDataLen, byte[] BlockData);
		int M0Halt();

		int FpCapFeature(byte[] Feature, int[] FeatureLen);
		int FpMatchFeature(int FeatureLen1, byte[] Feature1, int FeatureLen2, byte[] Feature2, int[] Score);

		int SsseReadCard(int iType, byte[] SSCardInfo, byte[] SSErrorInfo);
		int SsseGetCardInfo(String Tag, byte[] SSCardInfo);

		int IccGetCardInfo(int ICtype, String AIDList, String TagList, byte[] IcCardInfo);
		int IccGetARQC(int ICtype, String trData, String AIDList, byte[] ARQC, byte[] trAppData);
		int IccARPCExeScript(int ICtype, String trData, String ARPC, String trAppData, byte[] ScriptResult, byte[] TC);
		int IccVerifyScript(int ICtype, String trData, String ARPC, String trAppData, byte[] ScriptResult, byte[] TC);
		int IccGetTrDetail(int ICtype, String AIDList, byte[] TrDetail);
		int IccGetLoadDetail(int ICtype, String AIDList, byte[] LoadDetail);

		int HexToAsc(byte[] Hex, int HexLength, byte[] Asc);
		int AscToHex(String Asc, int HexLength, byte[] Hex);
	}
	public static void printMenu(){
		System.out.println("****************************");
		System.out.println("*** 1.豸");
		System.out.println("*** 2.ȡ֤");
		System.out.println("*** 3.ȡпϢ");
		System.out.println("*** 4.ȡ籣Ϣ");
		System.out.println("*** 5.M1Ѱ");
		System.out.println("*** 6.˳");
		System.out.println("****************************");
		System.out.println();
	}
	public static void main(String[] args) { 	
		int option = 0;
		int handle = 0;
		int ret = 0;
		Scanner cin = new Scanner(System.in);
		printMenu();
		while(cin.hasNext()){
			option = cin.nextInt();
			try{
				switch(option){
				case 1:
					handle = CommonInterface.instance.OpenDevice("AUTO", "", "");
					if(handle > 0){
						System.out.println("豸ɹ.");
					}
					else{
						System.out.println("豸ʧ.");
					}
					break;
				case 2:
					byte[] IdCardInfo = new byte[30000];
					ret = CommonInterface.instance.IdReadCard((byte)0x10, (byte)0x01, IdCardInfo, 0);
					if(ret != 0){
						System.out.println("ȡ֤ʧܡ");
					}
					else{
						System.out.println("ȡ֤ɹ");
						String s = new String(IdCardInfo, "GBK").trim();
						System.out.println(s);
					}
					break;
				case 3:
					byte[] TagList = new byte[100];
					ret = CommonInterface.instance.IccGetCardInfo(2, "", "A", TagList);
					if(ret != 0){
						System.out.println("ȡпϢʧܡ");
					}
					else{
						System.out.println("ȡпϢɹ");
						String s = new String(TagList, "GBK").trim();
						System.out.println(s);
					}
					break;
				case 4:
					byte[] SSCardInfo = new byte[1000];
					byte[] SSErrorInfo = new byte[1000];
					ret = CommonInterface.instance.SsseReadCard(3, SSCardInfo, SSErrorInfo);
					if(ret != 0){
						System.out.println("ȡ籣ϢʧܣϢ");
						String s = new String(SSErrorInfo, "GBK").trim();
						System.out.println(s);
					}
					else{
						System.out.println("ȡ籣Ϣɹ");
						String s = new String(SSCardInfo, "GBK").trim();
						System.out.println(s);
					}
					break;
				case 5:
					byte[] UID = new byte[100];
					int[] UIDLen = new int[1];
					ret = CommonInterface.instance.M1FindCard(UID, UIDLen);
					if(ret != 0){
						System.out.println("M1Ѱʧܡ");
					}
					else{
						System.out.println("M1ѰɹƬUID");
						StringBuilder sb = new StringBuilder();
						for(int i = 0; i < UIDLen[0]; i++) {
							sb.append(String.format("%02x", UID[i]));
						}
						System.out.println(sb.toString());
					}
					break;
				case 6:
					ret = CommonInterface.instance.CloseDevice();
					if(ret == 0){
						System.out.println("رճɹ");
					}
					break;
				default:
					break;	
				}
			}
			catch(UnsupportedEncodingException e){
				e.printStackTrace();
			}
			if(option == 6){
				break;
			}
			printMenu();
		}
		cin.close();
	}
}
