#include "mainwindow.h"
#include <QApplication>
#include <QString>
#include <QDir>
#include <QMessageBox>
#include <unistd.h>

_SetTerminalLibrary         pSetTerminalLibrary;
_SetAutoPara                pSetAutoPara;
_OpenDevice                 pOpenDevice;
_SetCurrentDevice           pSetCurrentDevice;
_GetCurrentDevice           pGetCurrentDevice;
_CloseDevice                pCloseDevice;
_TerminalGetModel           pTerminalGetModel;
_TerminalGetFirmVersion		pTerminalGetFirmVersion;
_TerminalHeartBeat          pTerminalHeartBeat;
_GetLastRecvData            pGetLastRecvData;
_IdFindCard                 pIdFindCard;
_IdSelectCard               pIdSelectCard;
_IdReadBaseMsg              pIdReadBaseMsg;
_IdReadBaseFpMsg            pIdReadBaseFpMsg;
_IdReadNewAppMsg            pIdReadNewAppMsg;
_IdReadSn                   pIdReadSn;
_IdApdu                     pIdApdu;
_SdtFindCard                pSdtFindCard;
_SdtSelectCard              pSdtSelectCard;
_SdtReadBaseMsg             pSdtReadBaseMsg;
_SdtReadBaseFpMsg           pSdtReadBaseFpMsg;
_SdtReadNewAppMsg           pSdtReadNewAppMsg;
_SamGetStatus               pSamGetStatus;
_SamGetId                   pSamGetId;
_SamGetIdStr                pSamGetIdStr;
_SdtSamGetStatus            pSdtSamGetStatus;
_SdtSamGetId                pSdtSamGetId;
_SdtSamGetIdStr             pSdtSamGetIdStr;
_IdReadCard                 pIdReadCard;
_SdtReadCard                pSdtReadCard;
_IdReadNewAddress           pIdReadNewAddress;
_SdtReadNewAddress          pSdtReadNewAddress;
_IdCardGetRawInfo           pIdCardGetRawInfo;
_IdCardGetName              pIdCardGetName;
_IdCardGetNameEn            pIdCardGetNameEn;
_IdCardGetGender            pIdCardGetGender;
_IdCardGetGenderId          pIdCardGetGenderId;
_IdCardGetNation            pIdCardGetNation;
_IdCardGetNationId          pIdCardGetNationId;
_IdCardGetBirthDate         pIdCardGetBirthDate;
_IdCardGetAddress           pIdCardGetAddress;
_IdCardGetIdNumber          pIdCardGetIdNumber;
_IdCardGetSignOrgan         pIdCardGetSignOrgan;
_IdCardGetBeginTerm         pIdCardGetBeginTerm;
_IdCardGetValidTerm         pIdCardGetValidTerm;
_IdCardGetTypeFlag          pIdCardGetTypeFlag;
_IdCardGetVersion           pIdCardGetVersion;
_IdCardGetFPBuffer          pIdCardGetFPBuffer;
_IdCardGetPhotoFile         pIdCardGetPhotoFile;
_IdCardGetPhotoBuffer		pIdCardGetPhotoBuffer;
_MagRead                    pMagRead;
_MagWrite                   pMagWrite;
_QrRead                     pQrRead;
_CpuPowerOn                 pCpuPowerOn;
_CpuApdu                    pCpuApdu;
_CpuPowerOff                pCpuPowerOff;
_M1FindCard                 pM1FindCard;
_M1Authentication           pM1Authentication;
_M1ReadBlock                pM1ReadBlock;
_M1WriteBlock               pM1WriteBlock;
_M1Halt                     pM1Halt;
_M0FindCard                 pM0FindCard;
_M0Authentication           pM0Authentication;
_M0ReadBlock                pM0ReadBlock;
_M0WriteBlock               pM0WriteBlock;
_M0Halt                     pM0Halt;
_FpCapFeature               pFpCapFeature;
_FpMatchFeature             pFpMatchFeature;
_SsseReadCard               pSsseReadCard;
_SsseGetCardInfo            pSsseGetCardInfo;
_IccGetCardInfo             pIccGetCardInfo;
_IccGetARQC                 pIccGetARQC;
_IccARPCExeScript           pIccARPCExeScript;
_IccVerifyScript            pIccVerifyScript;
_IccGetTrDetail             pIccGetTrDetail;
_IccGetLoadDetail           pIccGetLoadDetail;
_HexToAsc                   pHexToAsc;
_AscToHex                   pAscToHex;

bool LoadCommonInterface(char *DllFileName)
{
    HINSTANCE hDll = LoadLibraryM(DllFileName);
    if(hDll == NULL)
    {
        return false;
    }

    pSetTerminalLibrary		= (_SetTerminalLibrary)GetProcAddress(hDll, "SetTerminalLibrary");
    pSetAutoPara            = (_SetAutoPara)GetProcAddress(hDll, "SetAutoPara");
    pOpenDevice             = (_OpenDevice)GetProcAddress(hDll, "OpenDevice");
    pSetCurrentDevice		= (_SetCurrentDevice)GetProcAddress(hDll, "SetCurrentDevice");
    pGetCurrentDevice		= (_GetCurrentDevice)GetProcAddress(hDll, "GetCurrentDevice");
    pCloseDevice            = (_CloseDevice)GetProcAddress(hDll, "CloseDevice");
    pTerminalGetModel		= (_TerminalGetModel)GetProcAddress(hDll, "TerminalGetModel");
    pTerminalGetFirmVersion	= (_TerminalGetFirmVersion)GetProcAddress(hDll, "TerminalGetFirmVersion");
    pTerminalHeartBeat		= (_TerminalHeartBeat)GetProcAddress(hDll, "TerminalHeartBeat");
    pGetLastRecvData		= (_GetLastRecvData)GetProcAddress(hDll, "GetLastRecvData");
    pIdFindCard             = (_IdFindCard)GetProcAddress(hDll, "IdFindCard");
    pIdSelectCard           = (_IdSelectCard)GetProcAddress(hDll, "IdSelectCard");
    pIdReadBaseMsg          = (_IdReadBaseMsg)GetProcAddress(hDll, "IdReadBaseMsg");
    pIdReadBaseFpMsg		= (_IdReadBaseFpMsg)GetProcAddress(hDll, "IdReadBaseFpMsg");
    pIdReadNewAppMsg		= (_IdReadNewAppMsg)GetProcAddress(hDll, "IdReadNewAppMsg");
    pIdReadSn               = (_IdReadSn)GetProcAddress(hDll, "IdReadSn");
    pIdApdu                 = (_IdApdu)GetProcAddress(hDll, "IdApdu");
    pSdtFindCard            = (_SdtFindCard)GetProcAddress(hDll, "SdtFindCard");
    pSdtSelectCard          = (_SdtSelectCard)GetProcAddress(hDll, "SdtSelectCard");
    pSdtReadBaseMsg         = (_SdtReadBaseMsg)GetProcAddress(hDll, "SdtReadBaseMsg");
    pSdtReadBaseFpMsg		= (_SdtReadBaseFpMsg)GetProcAddress(hDll, "SdtReadBaseFpMsg");
    pSdtReadNewAppMsg		= (_SdtReadNewAppMsg)GetProcAddress(hDll, "SdtReadNewAppMsg");
    pSamGetStatus           = (_SamGetStatus)GetProcAddress(hDll, "SamGetStatus");
    pSamGetId               = (_SamGetId)GetProcAddress(hDll, "SamGetId");
    pSamGetIdStr            = (_SamGetIdStr)GetProcAddress(hDll, "SamGetIdStr");
    pSdtSamGetStatus		= (_SdtSamGetStatus)GetProcAddress(hDll, "SdtSamGetStatus");
    pSdtSamGetId            = (_SdtSamGetId)GetProcAddress(hDll, "SdtSamGetId");
    pSdtSamGetIdStr         = (_SdtSamGetIdStr)GetProcAddress(hDll, "SdtSamGetIdStr");
    pIdReadCard             = (_IdReadCard)GetProcAddress(hDll, "IdReadCard");
    pSdtReadCard            = (_SdtReadCard)GetProcAddress(hDll, "SdtReadCard");
    pIdReadNewAddress		= (_IdReadNewAddress)GetProcAddress(hDll, "IdReadNewAddress");
    pSdtReadNewAddress		= (_SdtReadNewAddress)GetProcAddress(hDll, "SdtReadNewAddress");
    pIdCardGetRawInfo		= (_IdCardGetRawInfo)GetProcAddress(hDll, "IdCardGetRawInfo");
    pIdCardGetName          = (_IdCardGetName)GetProcAddress(hDll, "IdCardGetName");
    pIdCardGetNameEn		= (_IdCardGetNameEn)GetProcAddress(hDll, "IdCardGetNameEn");
    pIdCardGetGender		= (_IdCardGetGender)GetProcAddress(hDll, "IdCardGetGender");
    pIdCardGetGenderId		= (_IdCardGetGenderId)GetProcAddress(hDll, "IdCardGetGenderId");
    pIdCardGetNation		= (_IdCardGetNation)GetProcAddress(hDll, "IdCardGetNation");
    pIdCardGetNationId		= (_IdCardGetNationId)GetProcAddress(hDll, "IdCardGetNationId");
    pIdCardGetBirthDate		= (_IdCardGetBirthDate)GetProcAddress(hDll, "IdCardGetBirthDate");
    pIdCardGetAddress		= (_IdCardGetAddress)GetProcAddress(hDll, "IdCardGetAddress");
    pIdCardGetIdNumber		= (_IdCardGetIdNumber)GetProcAddress(hDll, "IdCardGetIdNumber");
    pIdCardGetSignOrgan		= (_IdCardGetSignOrgan)GetProcAddress(hDll, "IdCardGetSignOrgan");
    pIdCardGetBeginTerm		= (_IdCardGetBeginTerm)GetProcAddress(hDll, "IdCardGetBeginTerm");
    pIdCardGetValidTerm		= (_IdCardGetValidTerm)GetProcAddress(hDll, "IdCardGetValidTerm");
    pIdCardGetTypeFlag		= (_IdCardGetTypeFlag)GetProcAddress(hDll, "IdCardGetTypeFlag");
    pIdCardGetVersion		= (_IdCardGetVersion)GetProcAddress(hDll, "IdCardGetVersion");
    pIdCardGetFPBuffer		= (_IdCardGetFPBuffer)GetProcAddress(hDll, "IdCardGetFPBuffer");
    pIdCardGetPhotoFile		= (_IdCardGetPhotoFile)GetProcAddress(hDll, "IdCardGetPhotoFile");
    pIdCardGetPhotoBuffer	= (_IdCardGetPhotoBuffer)GetProcAddress(hDll, "IdCardGetPhotoBuffer");
    pMagRead                = (_MagRead)GetProcAddress(hDll, "MagRead");
    pMagWrite               = (_MagWrite)GetProcAddress(hDll, "MagWrite");
    pQrRead                 = (_QrRead)GetProcAddress(hDll, "QrRead");
    pCpuPowerOn             = (_CpuPowerOn)GetProcAddress(hDll, "CpuPowerOn");
    pCpuApdu                = (_CpuApdu)GetProcAddress(hDll, "CpuApdu");
    pCpuPowerOff            = (_CpuPowerOff)GetProcAddress(hDll, "CpuPowerOff");
    pM1FindCard             = (_M1FindCard)GetProcAddress(hDll, "M1FindCard");
    pM1Authentication		= (_M1Authentication)GetProcAddress(hDll, "M1Authentication");
    pM1ReadBlock            = (_M1ReadBlock)GetProcAddress(hDll, "M1ReadBlock");
    pM1WriteBlock           = (_M1WriteBlock)GetProcAddress(hDll, "M1WriteBlock");
    pM1Halt                 = (_M1Halt)GetProcAddress(hDll, "M1Halt");
    pM0FindCard             = (_M0FindCard)GetProcAddress(hDll, "M0FindCard");
    pM0Authentication		= (_M0Authentication)GetProcAddress(hDll, "M0Authentication");
    pM0ReadBlock            = (_M0ReadBlock)GetProcAddress(hDll, "M0ReadBlock");
    pM0WriteBlock           = (_M0WriteBlock)GetProcAddress(hDll, "M0WriteBlock");
    pM0Halt                 = (_M0Halt)GetProcAddress(hDll, "M0Halt");
    pFpCapFeature           = (_FpCapFeature)GetProcAddress(hDll, "FpCapFeature");
    pFpMatchFeature         = (_FpMatchFeature)GetProcAddress(hDll, "FpMatchFeature");
    pSsseReadCard           = (_SsseReadCard)GetProcAddress(hDll, "SsseReadCard");
    pSsseGetCardInfo		= (_SsseGetCardInfo)GetProcAddress(hDll, "SsseGetCardInfo");
    pIccGetCardInfo         = (_IccGetCardInfo)GetProcAddress(hDll, "IccGetCardInfo");
    pIccGetARQC             = (_IccGetARQC)GetProcAddress(hDll, "IccGetARQC");
    pIccARPCExeScript		= (_IccARPCExeScript)GetProcAddress(hDll, "IccARPCExeScript");
    pIccVerifyScript		= (_IccVerifyScript)GetProcAddress(hDll, "IccVerifyScript");
    pIccGetTrDetail         = (_IccGetTrDetail)GetProcAddress(hDll, "IccGetTrDetail");
    pIccGetLoadDetail		= (_IccGetLoadDetail)GetProcAddress(hDll, "IccGetLoadDetail");
    pHexToAsc               = (_HexToAsc)GetProcAddress(hDll, "HexToAsc");
    pAscToHex               = (_AscToHex)GetProcAddress(hDll, "AscToHex");

    return true;
}

QString ExePath;

int main(int argc, char *argv[])
{
    ExePath = QDir::currentPath()+"/";

    QApplication a(argc, argv);

    char DllPath[1024] = {0};
    sprintf(DllPath, "%s%s", ExePath.toStdString().c_str(), "libCommonInterface.so");
    if(!LoadCommonInterface(DllPath))
    {
        QMessageBox::critical(0, "错误提示", "libCommonInterface.so加载失败");
        return -1;
    }

    MainWindow w;
    w.show();

    return a.exec();
}
