#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "dialog.h"
#include <QDesktopWidget>
#include <QTextCodec>
#include <QByteArray>
#include <QImage>

extern	_SetTerminalLibrary         pSetTerminalLibrary;
extern	_SetAutoPara                pSetAutoPara;
extern	_OpenDevice                 pOpenDevice;
extern	_SetCurrentDevice           pSetCurrentDevice;
extern	_GetCurrentDevice           pGetCurrentDevice;
extern	_CloseDevice                pCloseDevice;
extern	_TerminalGetModel           pTerminalGetModel;
extern	_TerminalGetFirmVersion		pTerminalGetFirmVersion;
extern	_TerminalHeartBeat          pTerminalHeartBeat;
extern	_GetLastRecvData            pGetLastRecvData;
extern	_IdFindCard                 pIdFindCard;
extern	_IdSelectCard               pIdSelectCard;
extern	_IdReadBaseMsg              pIdReadBaseMsg;
extern	_IdReadBaseFpMsg            pIdReadBaseFpMsg;
extern	_IdReadNewAppMsg            pIdReadNewAppMsg;
extern	_IdReadSn                   pIdReadSn;
extern	_IdApdu                     pIdApdu;
extern	_SdtFindCard                pSdtFindCard;
extern	_SdtSelectCard              pSdtSelectCard;
extern	_SdtReadBaseMsg             pSdtReadBaseMsg;
extern	_SdtReadBaseFpMsg           pSdtReadBaseFpMsg;
extern	_SdtReadNewAppMsg           pSdtReadNewAppMsg;
extern	_SamGetStatus               pSamGetStatus;
extern	_SamGetId                   pSamGetId;
extern	_SamGetIdStr                pSamGetIdStr;
extern	_SdtSamGetStatus            pSdtSamGetStatus;
extern	_SdtSamGetId                pSdtSamGetId;
extern	_SdtSamGetIdStr             pSdtSamGetIdStr;
extern	_IdReadCard                 pIdReadCard;
extern	_SdtReadCard                pSdtReadCard;
extern	_IdReadNewAddress           pIdReadNewAddress;
extern	_SdtReadNewAddress          pSdtReadNewAddress;
extern	_IdCardGetRawInfo           pIdCardGetRawInfo;
extern	_IdCardGetName              pIdCardGetName;
extern	_IdCardGetNameEn            pIdCardGetNameEn;
extern	_IdCardGetGender            pIdCardGetGender;
extern	_IdCardGetGenderId          pIdCardGetGenderId;
extern	_IdCardGetNation            pIdCardGetNation;
extern	_IdCardGetNationId          pIdCardGetNationId;
extern	_IdCardGetBirthDate         pIdCardGetBirthDate;
extern	_IdCardGetAddress           pIdCardGetAddress;
extern	_IdCardGetIdNumber          pIdCardGetIdNumber;
extern	_IdCardGetSignOrgan         pIdCardGetSignOrgan;
extern	_IdCardGetBeginTerm         pIdCardGetBeginTerm;
extern	_IdCardGetValidTerm         pIdCardGetValidTerm;
extern	_IdCardGetTypeFlag          pIdCardGetTypeFlag;
extern	_IdCardGetVersion           pIdCardGetVersion;
extern	_IdCardGetFPBuffer          pIdCardGetFPBuffer;
extern	_IdCardGetPhotoFile         pIdCardGetPhotoFile;
extern	_IdCardGetPhotoBuffer		pIdCardGetPhotoBuffer;
extern	_MagRead                    pMagRead;
extern	_MagWrite                   pMagWrite;
extern	_QrRead                     pQrRead;
extern	_CpuPowerOn                 pCpuPowerOn;
extern	_CpuApdu                    pCpuApdu;
extern	_CpuPowerOff                pCpuPowerOff;
extern	_M1FindCard                 pM1FindCard;
extern	_M1Authentication           pM1Authentication;
extern	_M1ReadBlock                pM1ReadBlock;
extern	_M1WriteBlock               pM1WriteBlock;
extern	_M1Halt                     pM1Halt;
extern	_M0FindCard                 pM0FindCard;
extern	_M0Authentication           pM0Authentication;
extern	_M0ReadBlock                pM0ReadBlock;
extern	_M0WriteBlock               pM0WriteBlock;
extern	_M0Halt                     pM0Halt;
extern	_FpCapFeature               pFpCapFeature;
extern	_FpMatchFeature             pFpMatchFeature;
extern	_SsseReadCard               pSsseReadCard;
extern	_SsseGetCardInfo            pSsseGetCardInfo;
extern	_IccGetCardInfo             pIccGetCardInfo;
extern	_IccGetARQC                 pIccGetARQC;
extern	_IccARPCExeScript           pIccARPCExeScript;
extern	_IccVerifyScript            pIccVerifyScript;
extern	_IccGetTrDetail             pIccGetTrDetail;
extern	_IccGetLoadDetail           pIccGetLoadDetail;
extern	_HexToAsc                   pHexToAsc;
extern	_AscToHex                   pAscToHex;

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{   
    ui->setupUi(this);
    ui->tabWidget->setVisible(false);

    QDesktopWidget *deskdop=QApplication::desktop();
    move((deskdop->width()-this->width())/2, (deskdop->height()-this->height())/2);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::on_pushButton_clicked()
{
    char IdCardInfo[10240] = {0};
    long ret = pIdReadCard(0, 1, IdCardInfo, 0);
    //QString info2 = QString::fromUtf16((ushort*)IdCardInfo);
    if (ret != 0)
    {
        ui->label_Tip->setText("读取证件信息失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("读取证件信息成功");
    QString info = QTextCodec::codecForName("GB18030")->toUnicode(IdCardInfo);

    QStringList CardInfo = info.split(":");

    ui->lineEdit_name->setText(CardInfo[1]);
    ui->lineEdit_gender->setText(CardInfo[3]);
    ui->lineEdit_nation->setText(CardInfo[5]);
    ui->lineEdit_birthday->setText(CardInfo[7]);
    ui->textEdit_address->setText(CardInfo[8]);
    ui->lineEdit_idnumber->setText(CardInfo[9]);
    ui->lineEdit_signorg->setText(CardInfo[10]);
    ui->lineEdit_valid->setText(CardInfo[11] + " - " + CardInfo[12]);
    QString MoreInfo = "证件类型标识：" + CardInfo[0];
    switch (CardInfo[0].at(0).toLatin1())
    {
        case 'I':
            {
                MoreInfo += "  英文姓名：" + CardInfo[2] + "  证件版本号：" + CardInfo[13];
                break;
            }
        case 'J':
            {
                MoreInfo += "  通行证号码：" + CardInfo[6] + "  签发次数：" + CardInfo[13];
                break;
            }
    }

    ui->lineEdit_other->setText(MoreInfo);

    QByteArray photo = QByteArray::fromBase64(CardInfo[14].toLatin1());
    ui->label_photo->setPixmap(QPixmap::fromImage(QImage::fromData(photo)));
}

void MainWindow::on_pushButton_2_clicked()
{
    char IdCardInfo[10240] = {0};
    long ret = pSdtReadCard(0, 1, IdCardInfo, 0);
    if (ret != 0)
    {
        ui->label_Tip->setText("读取证件信息失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("读取证件信息成功");
    QString info = QTextCodec::codecForName("GB18030")->toUnicode(IdCardInfo);

    QStringList CardInfo = info.split(":");

    ui->lineEdit_name->setText(CardInfo[1]);
    ui->lineEdit_gender->setText(CardInfo[3]);
    ui->lineEdit_nation->setText(CardInfo[5]);
    ui->lineEdit_birthday->setText(CardInfo[7]);
    ui->textEdit_address->setText(CardInfo[8]);
    ui->lineEdit_idnumber->setText(CardInfo[9]);
    ui->lineEdit_signorg->setText(CardInfo[10]);
    ui->lineEdit_valid->setText(CardInfo[11] + " - " + CardInfo[12]);
    QString MoreInfo = "证件类型标识：" + CardInfo[0];
    switch (CardInfo[0].at(0).toLatin1())
    {
        case 'I':
            {
                MoreInfo += "  英文姓名：" + CardInfo[2] + "  证件版本号：" + CardInfo[13];
                break;
            }
        case 'J':
            {
                MoreInfo += "  通行证号码：" + CardInfo[6] + "  签发次数：" + CardInfo[13];
                break;
            }
    }

    ui->lineEdit_other->setText(MoreInfo);

    QByteArray photo = QByteArray::fromBase64(CardInfo[14].toLatin1());
    ui->label_photo->setPixmap(QPixmap::fromImage(QImage::fromData(photo)));
}

void MainWindow::on_pushButton_3_clicked()
{
    unsigned char SN[16] = {0};
    long SNLen = 0;
    long ret = pIdReadSn(SN, &SNLen);
    if (ret != 0)
    {
        ui->label_Tip->setText("读二代证卡体管理号SN失败，错误代码：" + QString::number(ret));
        return;
    }

    char SnStr[16] = {0};
    pHexToAsc(SN, SNLen, SnStr);

    ui->label_Tip->setText("读二代证卡体管理号SN成功：" + QString(SnStr));
}

void MainWindow::on_pushButton_6_clicked()
{
    char CardInfo[4096] = {0};
    long ret = pIccGetCardInfo(2, "", (char*)ui->lineEdit_TagList->text().toStdString().c_str(), CardInfo);
    if (ret != 0)
    {
        ui->label_Tip->setText("读取银行卡信息失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("读取银行卡信息成功");

    ui->textEdit_IccInfo->setText(CardInfo);
}

void MainWindow::on_pushButton_7_clicked()
{
    char ARQC[4096] = {0};
    char trAppData[4096] = {0};
    long ret = pIccGetARQC(2, (char*)ui->lineEdit_ARQCData->text().toStdString().c_str(), "", ARQC, trAppData);
    if (ret != 0)
    {
        ui->label_Tip->setText("获取ARQC失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("获取ARQC成功");

    ui->textEdit_IccInfo->setText("ARQC：" + QString(ARQC) + "\r\ntrAppData：" + QString(trAppData));
    ui->lineEdit_TrAppData->setText(trAppData);
}

void MainWindow::on_pushButton_8_clicked()
{
    char ScriptResult[4096] = {0};
    char TC[4096] = {0};
    long ret = pIccARPCExeScript(2, (char*)ui->lineEdit_ARQCData->text().toStdString().c_str(), (char*)ui->lineEdit_ARPC->text().toStdString().c_str(), (char*)ui->lineEdit_TrAppData->text().toStdString().c_str(), ScriptResult, TC);
    if (ret != 0)
    {
        ui->label_Tip->setText("执行脚本失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("执行脚本成功");

    ui->textEdit_IccInfo->setText("ScriptResult：" + QString(ScriptResult) + "\r\nTC：" + QString(TC));
}

void MainWindow::on_pushButton_9_clicked()
{
    char TxDetail[4096] = {0};
    long ret = pIccGetTrDetail(2, "", TxDetail);
    if (ret != 0)
    {
        ui->label_Tip->setText("读交易明细失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("读交易明细成功");

    ui->textEdit_IccInfo->setText("TxDetail：" + QString(TxDetail));
}

void MainWindow::on_pushButton_10_clicked()
{
    char TxDetail[4096] = {0};
    long ret = pIccGetLoadDetail(2, "", TxDetail);
    if (ret != 0)
    {
        ui->label_Tip->setText("读圈存记录失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("读圈存记录成功");

    ui->textEdit_IccInfo->setText("TxDetail：" + QString(TxDetail));
}

void MainWindow::on_pushButton_11_clicked()
{
    char SSCardInfo[4096] = {0};
    char ErrorInfo[4096] = {0};
    long ret = pSsseReadCard(3, SSCardInfo, ErrorInfo);
    if (ret != 0)
    {
        ui->label_Tip->setText("读取社保卡信息失败，错误代码：" + QString::number(ret) + "  " + QString(ErrorInfo));
        return;
    }

    ui->label_Tip->setText("读取社保卡信息成功");

    QString info = QTextCodec::codecForName("GB18030")->toUnicode(SSCardInfo);

    QStringList CardInfo = info.split(":");

    ui->lineEdit_SsseCardNumber->setText(CardInfo[6]);
    ui->lineEdit_SsseCategory->setText(CardInfo[1]);
    ui->lineEdit_SsseStandardVersion->setText(CardInfo[2]);
    ui->lineEdit_SsseBegin->setText(CardInfo[4]);
    ui->lineEdit_SsseValid->setText(CardInfo[5]);
    ui->lineEdit_SsseInitOrg->setText(CardInfo[3]);
    ui->lineEdit_SsseIdentityNumber->setText(CardInfo[0]);
    ui->lineEdit_SsseIdNumber->setText(CardInfo[7]);
    ui->lineEdit_SsseName->setText(CardInfo[8]);
    ui->lineEdit_SsseGender->setText(CardInfo[10]);
    ui->lineEdit_SsseNation->setText(CardInfo[11]);
    ui->lineEdit_SsseBirthPlace->setText(CardInfo[12]);
    ui->lineEdit_SsseBirthDate->setText(CardInfo[13]);
}

void MainWindow::on_pushButton_12_clicked()
{
    unsigned char UID[16] = {0};
    long UIDLen = 0;
    long ret = pM1FindCard(UID, &UIDLen);
    if (ret != 0)
    {
        ui->label_Tip->setText("M1卡寻卡失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("M1卡寻卡成功");

    char UIDStr[32] = {0};
    pHexToAsc(UID, UIDLen, UIDStr);

    ui->lineEdit_UID->setText(UIDStr);
}

void MainWindow::on_pushButton_13_clicked()
{
    unsigned char KeyType = (unsigned char)ui->comboBox_KeyType->currentText().at(0).toLatin1();
    unsigned char SecAddr = (unsigned char)ui->lineEdit_SecAddr->text().toInt();
    unsigned char Key[16] = {0};
    unsigned char UID[16] = {0};
    if(ui->lineEdit_Key->text().length() != 12)
    {
        ui->label_Tip->setText("M1卡密钥长度错误，应为12个HEX字符（6个字节）");
        return;
    }

    pAscToHex((char*)ui->lineEdit_Key->text().toStdString().c_str(), 6, Key);
    pAscToHex((char*)ui->lineEdit_UID->text().toStdString().c_str(), 4, UID);

    long ret = pM1Authentication(KeyType, SecAddr, Key, UID);
    if (ret != 0)
    {
        ui->label_Tip->setText("M1卡密钥认证失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("M1卡密钥认证成功");
}

void MainWindow::on_pushButton_14_clicked()
{
    unsigned char BlockAddr = (unsigned char)ui->lineEdit_BlockAddr->text().toInt();
    unsigned char BlockData[32] = {0};
    long BlockDataLen = 0;
    long ret = pM1ReadBlock(BlockAddr, BlockData, &BlockDataLen);
    if (ret != 0)
    {
        ui->label_Tip->setText("M1卡读块数据失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("M1卡读块数据成功");

    char BlockDataStr[64] = {0};
    pHexToAsc(BlockData, BlockDataLen, BlockDataStr);
    ui->lineEdit_BlockData->setText(BlockDataStr);
}

void MainWindow::on_pushButton_15_clicked()
{
    unsigned char BlockAddr = (unsigned char)ui->lineEdit_BlockAddr->text().toInt();
    unsigned char BlockData[32] = {0};
    if (ui->lineEdit_WBlockData->text().length() != 32)
    {
        ui->label_Tip->setText("M1卡写块数据长度错误，应为32个HEX字符（16个字节）");
        return;
    }
    pAscToHex((char*)ui->lineEdit_WBlockData->text().toStdString().c_str(), 16, BlockData);
    long ret = pM1WriteBlock(BlockAddr, 16, BlockData);
    if (ret != 0)
    {
        ui->label_Tip->setText("M1卡写块数据失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("M1卡写块数据成功");
}

void MainWindow::on_pushButton_16_clicked()
{
    char track1[512] = {0};
    char track2[512] = {0};
    char track3[512] = {0};
    long ret = pMagRead((unsigned char)ui->comboBox_MagTracks->currentText().toInt(), track1, track2, track3, (unsigned char)ui->lineEdit_MagTimeOut->text().toInt());
    if (ret != 0)
    {
        ui->label_Tip->setText("读取磁条卡失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->lineEdit_MagTrack1->setText(track1);
    ui->lineEdit_MagTrack2->setText(track2);
    ui->lineEdit_MagTrack3->setText(track3);

    ui->label_Tip->setText("读取磁条卡成功");
}

void MainWindow::on_pushButton_17_clicked()
{
    long ret = pMagWrite((unsigned char)ui->comboBox_MagTracks->currentText().toInt(), (char*)ui->lineEdit_MagTrack1->text().toStdString().c_str(), (char*)ui->lineEdit_MagTrack2->text().toStdString().c_str(), (char*)ui->lineEdit_MagTrack3->text().toStdString().c_str(), (unsigned char)ui->lineEdit_MagTimeOut->text().toInt());
    if (ret != 0)
    {
        ui->label_Tip->setText("写入磁条卡失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("写入磁条卡成功");
}

void MainWindow::on_pushButton_18_clicked()
{
    unsigned char Slot[16] = {0};
    pAscToHex((char*)ui->comboBox_Slot->currentText().toStdString().c_str(), 1, Slot);
    unsigned char ATRS[128] = {0};
    long ATRSLen = 0;
    long ret = pCpuPowerOn(Slot[0], ATRS, &ATRSLen);
    if (ret != 0)
    {
        ui->label_Tip->setText("CPU卡上电失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("CPU卡上电成功");

    char ATRSStr[256] = {0};
    pHexToAsc(ATRS, ATRSLen, ATRSStr);

    ui->lineEdit_ATRS->setText(ATRSStr);
}

void MainWindow::on_pushButton_19_clicked()
{
    unsigned char Slot[16] = {0};
    unsigned char SendApdu[1024] = {0};
    long SendApduLen = ui->comboBox_SendApdu->currentText().length();
    if (SendApduLen % 2 != 0)
    {
        ui->label_Tip->setText("发送APDU的数据应为偶数个HEX字符");
        return;
    }
    SendApduLen = SendApduLen/2;

    pAscToHex((char*)ui->comboBox_SendApdu->currentText().toStdString().c_str(), SendApduLen, SendApdu);
    pAscToHex((char*)ui->comboBox_Slot->currentText().toStdString().c_str(), 1, Slot);

    unsigned char RecvApdu[1024] = {0};
    long RecvApduLen = 0;
    long ret = pCpuApdu(Slot[0], SendApduLen, SendApdu, RecvApdu, &RecvApduLen);
    if (ret != 0)
    {
        ui->label_Tip->setText("CPU卡发送APDU失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("CPU卡发送APDU成功");

    char RecvApduStr[2048] = {0};
    pHexToAsc(RecvApdu, RecvApduLen, RecvApduStr);

    ui->textEdit_RecvApdu->setText(RecvApduStr);
}

void MainWindow::on_pushButton_20_clicked()
{
    unsigned char Slot[16] = {0};
    pAscToHex((char*)ui->comboBox_Slot->currentText().toStdString().c_str(), 1, Slot);

    long ret = pCpuPowerOff(Slot[0]);
    if (ret != 0)
    {
        ui->label_Tip->setText("CPU卡下电失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("CPU卡下电成功");
}

void MainWindow::on_pushButton_21_clicked()
{
    char QrData[512] = {0};
    long ret = pQrRead(QrData, (unsigned char)ui->lineEdit_QrTimeOut->text().toInt());
    if (ret != 0)
    {
        ui->label_Tip->setText("读取二维码失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("读取二维码成功");

    ui->textEdit_QrData->setText(QrData);
}

void MainWindow::on_pushButton_22_clicked()
{
    long ret = pTerminalHeartBeat();
    if (ret != 0)
    {
        ui->label_Tip->setText("设备连接状态异常，错误代码：" + QString::number(ret));
        ui->textEdit_TestInfo->setText("设备未连接或状态异常");
        return;
    }

    ui->label_Tip->setText("设备连接状态正常");

    ui->textEdit_TestInfo->setText("设备连接状态正常");
}

void MainWindow::on_pushButton_23_clicked()
{
    char Model[256] = {0};
    long ret = pTerminalGetModel(Model);
    if (ret != 0)
    {
        ui->label_Tip->setText("读取设备型号失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("读取设备型号成功");

    ui->textEdit_TestInfo->setText(Model);
}

void MainWindow::on_pushButton_24_clicked()
{
    char FirmVersion[256] = {0};
    char HardwareVersion[256] = {0};
    long ret = pTerminalGetFirmVersion(FirmVersion, HardwareVersion);
    if (ret != 0)
    {
        ui->label_Tip->setText("读取固件版本号失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("读取固件版本号成功");

    ui->textEdit_TestInfo->setText("固件版本：" + QString(FirmVersion) + "\r\n硬件版本：" + QString(HardwareVersion));
}

void MainWindow::on_pushButton_25_clicked()
{
    char SamId[256] = {0};
    long ret = pSamGetIdStr(SamId);
    if (ret != 0)
    {
        ui->label_Tip->setText("读取SAM模块号失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("读取SAM模块号成功");

    ui->textEdit_TestInfo->setText(SamId);
}

void MainWindow::on_pushButton_27_clicked()
{
    char SamId[256] = {0};
    long ret = pSdtSamGetIdStr(SamId);
    if (ret != 0)
    {
        ui->label_Tip->setText("读取SAM模块号失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("读取SAM模块号成功");

    ui->textEdit_TestInfo->setText(SamId);
}

void MainWindow::on_pushButton_26_clicked()
{
    long ret = pSamGetStatus();
    if (ret != 0)
    {
        ui->label_Tip->setText("获取SAM模块状态失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("获取SAM模块状态成功");

    ui->textEdit_TestInfo->setText("SAM模块状态正常");
}

void MainWindow::on_pushButton_28_clicked()
{
    long ret = pSdtSamGetStatus();
    if (ret != 0)
    {
        ui->label_Tip->setText("获取SAM模块状态失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("获取SAM模块状态成功");

    ui->textEdit_TestInfo->setText("SAM模块状态正常");
}

void MainWindow::on_action_triggered()
{
    Dialog dlg(this);
    dlg.exec();

    if(dlg.Result == -1)
    {
        ui->label_Tip->setText("已取消端口选择");
        return;
    }

    long handle = pOpenDevice((char*)dlg.PortType.toStdString().c_str(), (char*)dlg.PortPara.toStdString().c_str(), (char*)dlg.ExtendPara.toStdString().c_str());
    if (handle <= 0)
    {
        ui->label_Tip->setText("打开设备失败，错误代码：" + QString::number(handle));
        return;
    }

    ui->label_Tip->setText("打开设备成功，设备句柄：" + QString::number(handle));

    ui->tabWidget->setVisible(true);
}

void MainWindow::on_action_2_triggered()
{
    long ret = pCloseDevice();
    if (ret != 0)
    {
        ui->label_Tip->setText("关闭设备失败，错误代码：" + QString::number(ret));
        return;
    }

    ui->label_Tip->setText("关闭设备成功");

    ui->tabWidget->setVisible(false);
}

void MainWindow::on_action_3_triggered()
{
    ui->label_Tip->setText("");
}
