/*
 * Decompiled with CFR 0.152.
 */
package com.hisign.AS60xSDK;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class SDKUtilty {
    private static final String TAG = "FingerSDKUtilty";
    private static Toast mToast = null;

    public static Bitmap scaleImg(Bitmap bm, int newWidth, int newHeight) {
        int width = bm.getWidth();
        int height = bm.getHeight();
        int newWidth1 = newWidth;
        int newHeight1 = newHeight;
        float scaleWidth = (float)newWidth1 / (float)width;
        float scaleHeight = (float)newHeight1 / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap newbm = Bitmap.createBitmap((Bitmap)bm, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return newbm;
    }

    public static Bitmap GetBitMapFromFilePath(Context ctxPt, String probe_path, int width, int height) {
        Uri probe_uri = Uri.fromFile((File)new File(probe_path));
        Bitmap bitmap = null;
        try {
            ContentResolver cr = ctxPt.getContentResolver();
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)cr.openInputStream(probe_uri), null, (BitmapFactory.Options)options);
            int imgSampleSize = options.outWidth > options.outHeight ? (options.outWidth + 360) / width : (options.outHeight + 360) / height;
            options.inSampleSize = imgSampleSize;
            options.inJustDecodeBounds = false;
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            bitmap = BitmapFactory.decodeStream((InputStream)cr.openInputStream(probe_uri), null, (BitmapFactory.Options)options);
        }
        catch (FileNotFoundException e) {
            String ldbResultStatus = "\u56fe\u7247\u89e3\u7801\u9519\u8bef\uff01";
            Toast.makeText((Context)ctxPt, (CharSequence)ldbResultStatus, (int)0).show();
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            String ldbResultStatus = "\u5185\u5b58\u4e0d\u8db3\u9519\u8bef\uff01";
            Toast.makeText((Context)ctxPt, (CharSequence)ldbResultStatus, (int)0).show();
            e.printStackTrace();
        }
        return bitmap;
    }

    public static int SaveRawToBmp(byte[] Rawdata, String fileName, int sensorType) {
        byte[] byArray = new byte[48];
        byArray[0] = 66;
        byArray[1] = 77;
        byArray[2] = 56;
        byArray[3] = -61;
        byArray[4] = 4;
        byArray[10] = 54;
        byArray[11] = 4;
        byArray[14] = 40;
        byArray[18] = -128;
        byArray[19] = 2;
        byArray[22] = -32;
        byArray[23] = 1;
        byArray[26] = 1;
        byArray[28] = 8;
        byArray[34] = 2;
        byArray[35] = -80;
        byArray[36] = 4;
        byArray[38] = 18;
        byArray[39] = 11;
        byArray[42] = 18;
        byArray[43] = 11;
        byte[] bmp_head_640x480 = byArray;
        byte[] byArray2 = new byte[48];
        byArray2[0] = 66;
        byArray2[1] = 77;
        byArray2[2] = 54;
        byArray2[3] = 108;
        byArray2[4] = 1;
        byArray2[10] = 54;
        byArray2[11] = 4;
        byArray2[14] = 40;
        byArray2[19] = 1;
        byArray2[22] = 104;
        byArray2[23] = 1;
        byArray2[26] = 1;
        byArray2[28] = 8;
        byArray2[47] = 1;
        byte[] bmp_head_256x360 = byArray2;
        byte[] bmp_colmap = new byte[4];
        byte[] fixarray = new byte[1024];
        int i = 0;
        while (i < 1024) {
            fixarray[i] = 0;
            ++i;
        }
        try {
            FileOutputStream stream = new FileOutputStream(fileName);
            if (sensorType == 1) {
                stream.write(bmp_head_640x480);
                stream.write(bmp_colmap, 0, 3);
                stream.write(bmp_colmap, 0, 3);
                int i2 = 0;
                while (i2 < 480) {
                    bmp_colmap[1] = bmp_colmap[2] = (byte)i2;
                    bmp_colmap[0] = bmp_colmap[2];
                    stream.write(bmp_colmap);
                    ++i2;
                }
                stream.write(Rawdata);
            } else if (sensorType == 2) {
                stream.write(bmp_head_256x360);
                stream.write(bmp_colmap, 0, 3);
                stream.write(bmp_colmap, 0, 3);
                int i3 = 0;
                while (i3 < 256) {
                    bmp_colmap[1] = bmp_colmap[2] = (byte)i3;
                    bmp_colmap[0] = bmp_colmap[2];
                    stream.write(bmp_colmap);
                    ++i3;
                }
                i3 = 0;
                while (i3 < 360) {
                    stream.write(Rawdata, (359 - i3) * 256, 256);
                    ++i3;
                }
            }
            stream.close();
        }
        catch (FileNotFoundException e) {
            return -2;
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }

    public static boolean dirIsExists(String dirName) {
        File file = new File(dirName);
        return file.exists() && file.isDirectory();
    }

    public static boolean dirIsExists(String dirName, boolean isCreate) {
        boolean ret;
        try {
            File f = new File(dirName);
            ret = !f.exists() ? (isCreate ? f.mkdirs() : false) : f.isDirectory();
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static boolean fileIsExists(String fileName) {
        try {
            File f = new File(fileName);
            return f.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean fileIsExists(String fileName, boolean isCreate) {
        block4: {
            try {
                File file = new File(fileName);
                if (!file.exists()) {
                    if (!isCreate) {
                        return false;
                    }
                    file.createNewFile();
                    break block4;
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static boolean deletefile(File f) {
        try {
            if (f.exists() && f.isFile()) {
                f.delete();
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean deletedir(File f) {
        if (f.isDirectory()) {
            Log.i((String)TAG, (String)"Now delet files.....");
            File[] files = f.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    SDKUtilty.deletedir(files[i]);
                } else {
                    SDKUtilty.deletefile(files[i]);
                }
                ++i;
            }
        }
        return true;
    }

    public static void mkDir(String pt) {
        File dir = new File(pt);
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    public static List<String> ReadStringArrayFromFile(String fileName) {
        ArrayList<String> stringList = new ArrayList<String>();
        try {
            FileInputStream fis = new FileInputStream(fileName);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, "GBK");
            BufferedReader reader = new BufferedReader(isr);
            String line = reader.readLine();
            while (line != null) {
                stringList.add(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringList;
    }

    public static void writeToSd(String filename, byte[] buf) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            fos.write(buf);
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeWzToSd(String filename, String[] str) {
        try {
            FileOutputStream out = new FileOutputStream(filename);
            String flag = "-";
            int i = 0;
            while (i < str.length - 3) {
                if (str[i] != null) {
                    out.write(str[i].getBytes("gbk"));
                    out.write(13);
                    out.write(10);
                }
                ++i;
            }
            out.write(str[7].getBytes("gbk"));
            out.write(flag.getBytes("gbk"));
            out.write(str[8].getBytes("gbk"));
            out.write(13);
            out.write(10);
            out.close();
            System.out.println("\u5199\u5165\u6210\u529f\uff01");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setBmpForView(Context context, ImageView[] imgViewArr, int fingPos, String fileInPath) {
        Bitmap facebmp = SDKUtilty.GetBitMapFromFilePath(context, fileInPath, 640, 640);
        int imgfingPos = fingPos == 10 ? 0 : fingPos;
        imgViewArr[imgfingPos].setImageBitmap(facebmp);
        imgViewArr[imgfingPos].setTag((Object)fingPos);
    }

    public static void print(String info) {
        Log.d((String)"avin", (String)info);
    }

    public static void printHint(Context context, String info) {
        Toast.makeText((Context)context, (CharSequence)info, (int)0).show();
    }

    public static void showToast(Context context, String msg, int duration) {
        if (mToast == null) {
            mToast = Toast.makeText((Context)context, (CharSequence)msg, (int)duration);
        } else {
            mToast.setText((CharSequence)msg);
        }
        mToast.show();
    }

    public static void imageMaxShow(Context context, int idView, String filePath) {
        ImageView iv = new ImageView(context);
        iv.setScaleType(ImageView.ScaleType.FIT_CENTER);
        String fileInPath = String.format("%s_%02d.bmp", filePath, idView);
        Bitmap facebmp = SDKUtilty.GetBitMapFromFilePath(context, fileInPath, 640, 640);
        facebmp = SDKUtilty.scaleImg(facebmp, 256, 320);
        iv.setImageBitmap(facebmp);
        AlertDialog.Builder alb = new AlertDialog.Builder(context);
        alb.setView((View)iv).setPositiveButton((CharSequence)"\u786e\u5b9a", null).show();
    }

    public static int CheckPackageSign(Context context) {
        try {
            String pkgname = context.getPackageName();
            PackageInfo pi = context.getPackageManager().getPackageInfo(pkgname, 64);
            Signature[] signs = pi.signatures;
            String pkgSign = signs[0].toCharsString();
            Log.d((String)TAG, (String)("pkgname" + pkgname + " SignHashIS:" + pkgSign));
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static void alertDialog(final Context context) {
        new AlertDialog.Builder(context).setTitle((CharSequence)"\u6ce8\u610f").setIcon(17301543).setMessage((CharSequence)"\u5f53\u524d\u91c7\u96c6\u672a\u5b8c\u6210\uff0c\u6b64\u65f6\u9000\u51fa\u53ef\u80fd\u4f1a\u5bfc\u81f4\u8bbe\u5907\u5f02\u5e38\uff01").setPositiveButton((CharSequence)"\u9000\u51fa", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
                ((Activity)context).finish();
                System.exit(0);
            }
        }).setNegativeButton((CharSequence)"\u53d6\u6d88", null).show();
    }

    public static boolean isArrayContains(String[] arr, int pos) {
        boolean rst = false;
        if (arr == null) {
            throw new NullPointerException("Array is null!");
        }
        if (String.valueOf(pos) == null) {
            throw new NullPointerException("pos is null!");
        }
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String tst = stringArray[n2];
            if (tst.equals(String.valueOf(pos))) {
                SDKUtilty.print("contains pos->" + pos);
                rst = true;
                break;
            }
            ++n2;
        }
        return rst;
    }

    public static String[] decodePersionInfo(byte[] dataBuf) {
        String[] decodeInfo = new String[10];
        try {
            String TmpStr = new String(dataBuf, "UTF16-LE");
            TmpStr = new String(TmpStr.getBytes("UTF-8"));
            decodeInfo[0] = TmpStr.substring(0, 15);
            decodeInfo[1] = TmpStr.substring(15, 16);
            decodeInfo[2] = TmpStr.substring(16, 18);
            decodeInfo[3] = TmpStr.substring(18, 26);
            decodeInfo[4] = TmpStr.substring(26, 61);
            decodeInfo[5] = TmpStr.substring(61, 79);
            decodeInfo[6] = TmpStr.substring(79, 94);
            decodeInfo[7] = TmpStr.substring(94, 102);
            decodeInfo[8] = TmpStr.substring(102, 110);
            decodeInfo[9] = TmpStr.substring(110, 128);
            decodeInfo[1] = decodeInfo[1].equals("1") ? "\u7537" : "\u5973";
            try {
                int code = Integer.parseInt(decodeInfo[2].toString());
                decodeInfo[2] = SDKUtilty.decodeNation(code);
            }
            catch (Exception e) {
                decodeInfo[2] = "";
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return decodeInfo;
    }

    public static String decodeNation(int code) {
        String nation;
        switch (code) {
            case 1: {
                nation = "\u6c49";
                break;
            }
            case 2: {
                nation = "\u8499\u53e4";
                break;
            }
            case 3: {
                nation = "\u56de";
                break;
            }
            case 4: {
                nation = "\u85cf";
                break;
            }
            case 5: {
                nation = "\u7ef4\u543e\u5c14";
                break;
            }
            case 6: {
                nation = "\u82d7";
                break;
            }
            case 7: {
                nation = "\u5f5d";
                break;
            }
            case 8: {
                nation = "\u58ee";
                break;
            }
            case 9: {
                nation = "\u5e03\u4f9d";
                break;
            }
            case 10: {
                nation = "\u671d\u9c9c";
                break;
            }
            case 11: {
                nation = "\u6ee1";
                break;
            }
            case 12: {
                nation = "\u4f97";
                break;
            }
            case 13: {
                nation = "\u7476";
                break;
            }
            case 14: {
                nation = "\u767d";
                break;
            }
            case 15: {
                nation = "\u571f\u5bb6";
                break;
            }
            case 16: {
                nation = "\u54c8\u5c3c";
                break;
            }
            case 17: {
                nation = "\u54c8\u8428\u514b";
                break;
            }
            case 18: {
                nation = "\u50a3";
                break;
            }
            case 19: {
                nation = "\u9ece";
                break;
            }
            case 20: {
                nation = "\u5088\u50f3";
                break;
            }
            case 21: {
                nation = "\u4f64";
                break;
            }
            case 22: {
                nation = "\u7572";
                break;
            }
            case 23: {
                nation = "\u9ad8\u5c71";
                break;
            }
            case 24: {
                nation = "\u62c9\u795c";
                break;
            }
            case 25: {
                nation = "\u6c34";
                break;
            }
            case 26: {
                nation = "\u4e1c\u4e61";
                break;
            }
            case 27: {
                nation = "\u7eb3\u897f";
                break;
            }
            case 28: {
                nation = "\u666f\u9887";
                break;
            }
            case 29: {
                nation = "\u67ef\u5c14\u514b\u5b5c";
                break;
            }
            case 30: {
                nation = "\u571f";
                break;
            }
            case 31: {
                nation = "\u8fbe\u65a1\u5c14";
                break;
            }
            case 32: {
                nation = "\u4eeb\u4f6c";
                break;
            }
            case 33: {
                nation = "\u7f8c";
                break;
            }
            case 34: {
                nation = "\u5e03\u6717";
                break;
            }
            case 35: {
                nation = "\u6492\u62c9";
                break;
            }
            case 36: {
                nation = "\u6bdb\u5357";
                break;
            }
            case 37: {
                nation = "\u4ee1\u4f6c";
                break;
            }
            case 38: {
                nation = "\u9521\u4f2f";
                break;
            }
            case 39: {
                nation = "\u963f\u660c";
                break;
            }
            case 40: {
                nation = "\u666e\u7c73";
                break;
            }
            case 41: {
                nation = "\u5854\u5409\u514b";
                break;
            }
            case 42: {
                nation = "\u6012";
                break;
            }
            case 43: {
                nation = "\u4e4c\u5b5c\u522b\u514b";
                break;
            }
            case 44: {
                nation = "\u4fc4\u7f57\u65af";
                break;
            }
            case 45: {
                nation = "\u9102\u6e29\u514b";
                break;
            }
            case 46: {
                nation = "\u5fb7\u6602";
                break;
            }
            case 47: {
                nation = "\u4fdd\u5b89";
                break;
            }
            case 48: {
                nation = "\u88d5\u56fa";
                break;
            }
            case 49: {
                nation = "\u4eac";
                break;
            }
            case 50: {
                nation = "\u5854\u5854\u5c14";
                break;
            }
            case 51: {
                nation = "\u72ec\u9f99";
                break;
            }
            case 52: {
                nation = "\u9102\u4f26\u6625";
                break;
            }
            case 53: {
                nation = "\u8d6b\u54f2";
                break;
            }
            case 54: {
                nation = "\u95e8\u5df4";
                break;
            }
            case 55: {
                nation = "\u73de\u5df4";
                break;
            }
            case 56: {
                nation = "\u57fa\u8bfa";
                break;
            }
            case 97: {
                nation = "\u5176\u4ed6";
                break;
            }
            case 98: {
                nation = "\u5916\u56fd\u8840\u7edf\u4e2d\u56fd\u7c4d\u4eba\u58eb";
                break;
            }
            default: {
                nation = "";
            }
        }
        return nation;
    }

    public static int SaveRawToBmp(byte[] Rawdata, String fileName, boolean isFlip) {
        byte[] byArray = new byte[48];
        byArray[0] = 66;
        byArray[1] = 77;
        byArray[2] = 54;
        byArray[3] = 108;
        byArray[4] = 1;
        byArray[10] = 54;
        byArray[11] = 4;
        byArray[14] = 40;
        byArray[19] = 1;
        byArray[22] = 104;
        byArray[23] = 1;
        byArray[26] = 1;
        byArray[28] = 8;
        byArray[47] = 1;
        byte[] bmp_head_256x360 = byArray;
        byte[] bmp_colmap = new byte[4];
        try {
            FileOutputStream stream = new FileOutputStream(fileName);
            stream.write(bmp_head_256x360);
            stream.write(bmp_colmap, 0, 3);
            stream.write(bmp_colmap, 0, 3);
            int i = 0;
            while (i < 256) {
                bmp_colmap[1] = bmp_colmap[2] = (byte)i;
                bmp_colmap[0] = bmp_colmap[2];
                stream.write(bmp_colmap);
                ++i;
            }
            i = 0;
            while (i < 360) {
                if (isFlip) {
                    stream.write(Rawdata, (359 - i) * 256, 256);
                } else {
                    stream.write(Rawdata, i * 256, 256);
                }
                ++i;
            }
            stream.close();
        }
        catch (FileNotFoundException e) {
            return -2;
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }

    public static int SaveRawToBmp_256_400(byte[] Rawdata, String fileName, boolean isFlip) {
        byte[] byArray = new byte[48];
        byArray[0] = 66;
        byArray[1] = 77;
        byArray[2] = 54;
        byArray[3] = 108;
        byArray[4] = 1;
        byArray[10] = 54;
        byArray[11] = 4;
        byArray[14] = 40;
        byArray[19] = 1;
        byArray[22] = -112;
        byArray[23] = 1;
        byArray[26] = 1;
        byArray[28] = 8;
        byArray[47] = 1;
        byte[] bmp_head = byArray;
        byte[] bmp_colmap = new byte[4];
        try {
            FileOutputStream stream = new FileOutputStream(fileName);
            stream.write(bmp_head);
            stream.write(bmp_colmap, 0, 3);
            stream.write(bmp_colmap, 0, 3);
            int i = 0;
            while (i < 256) {
                bmp_colmap[1] = bmp_colmap[2] = (byte)i;
                bmp_colmap[0] = bmp_colmap[2];
                stream.write(bmp_colmap);
                ++i;
            }
            i = 0;
            while (i < 400) {
                if (isFlip) {
                    stream.write(Rawdata, (399 - i) * 256, 256);
                } else {
                    stream.write(Rawdata, i * 256, 256);
                }
                ++i;
            }
            stream.close();
        }
        catch (FileNotFoundException e) {
            return -2;
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }

    public static int ReadBmpToRaw(byte[] Rawdata, String fileName, boolean isFlip) {
        byte[] bmp_head = new byte[1078];
        try {
            FileInputStream stream = new FileInputStream(fileName);
            stream.read(bmp_head, 0, 1078);
            int i = 0;
            while (i < 360) {
                if (isFlip) {
                    stream.read(Rawdata, (359 - i) * 256, 256);
                } else {
                    stream.read(Rawdata, i * 256, 256);
                }
                ++i;
            }
            stream.close();
        }
        catch (FileNotFoundException e) {
            return -2;
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }

    private static byte[] readFile(String path) throws Exception {
        File file = new File(path);
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        byte[] bs = new byte[(int)file.length()];
        dis.readFully(bs);
        dis.close();
        return bs;
    }

    private static void writeFile(String filePath, byte[] DataBuffer) {
        FileOutputStream fos = null;
        try {
            try {
                File file = new File(filePath);
                fos = new FileOutputStream(file);
                fos.write(DataBuffer);
                fos.flush();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    fos.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    fos.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean copyFile(String dstPath, String srcPath) {
        boolean rst = true;
        try {
            try {
                byte[] tempData = SDKUtilty.readFile(srcPath);
                SDKUtilty.writeFile(dstPath, tempData);
            }
            catch (Exception e) {
                rst = false;
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {}
        return rst;
    }
}

