/*
 * Decompiled with CFR 0.152.
 */
package cn.com.aratek.fp;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import cn.com.aratek.dev.AraError;
import cn.com.aratek.dev.IDevice;
import java.util.List;

public class FingerprintScanner
implements IDevice {
    protected static FingerprintScanner sScanner = null;

    static {
        System.loadLibrary("usb-1.0");
        System.loadLibrary("ftrScanAPI");
        System.loadLibrary("AraBMApiFpAlgorithm");
        System.loadLibrary("AraBMApiDev");
        System.loadLibrary("AraBMApiFp");
    }

    protected FingerprintScanner() {
    }

    public static FingerprintScanner getInstance() {
        if (sScanner != null) {
            return sScanner;
        }
        sScanner = new FingerprintScanner();
        return sScanner;
    }

    public native boolean powerOn(AraError var1);

    public native boolean powerOff(AraError var1);

    public native boolean open(AraError var1);

    public native boolean close(AraError var1);

    public native String getDeviceVersion(AraError var1);

    public native String getDeviceSN(AraError var1);

    public native byte[] captureRaw(AraError var1);

    public Bitmap capture(AraError error) {
        byte[] bmp;
        byte[] raw = this.captureRaw(error);
        if (raw != null && raw.length != 0 && (bmp = this.raw2Bmp(raw, error)) != null) {
            Bitmap img = BitmapFactory.decodeByteArray((byte[])bmp, (int)0, (int)bmp.length);
            if (img != null) {
                error.mErrorCode = 0;
                return img;
            }
            error.mErrorCode = -1007;
        }
        return null;
    }

    public native boolean cancel(AraError var1);

    public native byte[] raw2Bmp(byte[] var1, AraError var2);

    public native boolean hasFinger(AraError var1);

    public byte[] extract(AraError error) {
        byte[] raw = this.captureRaw(error);
        if (raw != null) {
            return this.extractFromRaw(raw, error);
        }
        return null;
    }

    public native byte[] extractFromRaw(byte[] var1, AraError var2);

    private static native byte[] extractFromRaw(byte[] var0, int var1, int var2, AraError var3);

    public native byte[] generalize(byte[] var1, byte[] var2, byte[] var3, AraError var4);

    public boolean verify(byte[] charData, byte[] tempData, int level, AraError error) {
        int score = this.verify(charData, tempData, error);
        if (error.mErrorCode == 0) {
            switch (level) {
                case 1: {
                    if (score >= 48) break;
                    error.mErrorCode = -2004;
                    break;
                }
                case 2: {
                    if (score >= 60) break;
                    error.mErrorCode = -2004;
                    break;
                }
                case 3: {
                    if (score >= 72) break;
                    error.mErrorCode = -2004;
                    break;
                }
                case 4: {
                    if (score >= 84) break;
                    error.mErrorCode = -2004;
                    break;
                }
                case 5: {
                    if (score >= 96) break;
                    error.mErrorCode = -2004;
                    break;
                }
                default: {
                    error.mErrorCode = -1006;
                }
            }
        }
        return error.mErrorCode == 0;
    }

    public native int verify(byte[] var1, byte[] var2, AraError var3);

    public native Result[] compareN(byte[] var1, List<byte[]> var2, int var3, AraError var4);

    public native float verifyWithIdcardFingerprint(byte[] var1, byte[] var2, AraError var3);

    public native int getFingerprintQuality(byte[] var1, AraError var2);

    public static final class Result {
        public int index;
        public int score;

        public Result(int index, int score) {
            this.index = index;
            this.score = score;
        }
    }
}

