/*
 * Decompiled with CFR 0.152.
 */
package com.sdses.bean;

import android.util.Log;
import com.sdses.bean.ID2DataRAW;
import com.sdses.bean.ID2FP;
import com.sdses.bean.ID2Pic;
import com.sdses.bean.ID2Txt;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class ID2Data
extends ID2DataRAW
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TAG = ID2Data.class.getSimpleName();
    private ID2Txt mID2Txt;
    private ID2Pic mID2Pic;
    private ID2FP mID2FP;
    private String mID2NewAddress;
    private boolean mHaveFP = false;

    public ID2Data() {
        Log.i((String)TAG, (String)"ID2Data \u6784\u9020\u51fd\u6570");
        this.mID2Txt = new ID2Txt();
        this.mID2Pic = new ID2Pic();
        this.mID2FP = new ID2FP();
    }

    public int rePackage() {
        this.mID2Txt.decode(this.getID2TxtRAW());
        this.mID2Pic.decodeNoLic(this.getID2PicRAW());
        this.mHaveFP = this.mID2FP.initFP(this.getID2FPRAW());
        try {
            this.mID2NewAddress = this.getID2AddRAW() == null ? null : new String(this.getID2AddRAW(), 3, 70, "UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    public int rePackage(byte[] idTxt, byte[] idPic, byte[] fp) {
        this.mID2Txt.decode(idTxt);
        this.mID2Pic.decodeNoLic(idPic);
        this.mHaveFP = this.mID2FP.initFP(fp);
        return 1;
    }

    public String getmID2NewAddress() {
        return this.mID2NewAddress;
    }

    public ID2Txt getmID2Txt() {
        return this.mID2Txt;
    }

    public ID2Pic getmID2Pic() {
        return this.mID2Pic;
    }

    public ID2FP getmID2FP() {
        if (this.mHaveFP) {
            return this.mID2FP;
        }
        return null;
    }
}

