/*
 * Decompiled with CFR 0.152.
 */
package com.sdses.common.impl;

import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import com.sdses.common.CardBoard;
import com.sdses.common.IReadIDCard;
import com.sdses.crc.CRC16CCITT;
import com.sdses.gpio.GPIOControl;
import com.sdses.instances.serviceEnum;
import com.sdses.serialport.Serialport;
import com.sdses.tool.SSUtil;
import com.sdses.values.readIDCardStatus;
import com.wits.LedcontrlActivity;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Arrays;

public class ReadCardFromSerialport
implements IReadIDCard {
    private static final String TAG = ReadCardFromSerialport.class.getSimpleName();
    private Serialport mCom = null;
    private CardBoard mCardBoard;
    private String mPath = "/dev/ttyMT2";
    private int mBaurd = 115200;
    private static byte[] pbuffer = new byte[10240];
    static byte[] sendToCom = new byte[4096];
    private int mBaud = 115200;
    public boolean comOpenFlag = false;

    public ReadCardFromSerialport() {
        Log.i((String)TAG, (String)"ReadCardFromSerialport");
        this.fpModulePowerOn();
        this.mCardBoard = new CardBoard();
    }

    private void fpModulePowerOn() {
        try {
            String path = "";
            String mDevModel = Build.MODEL;
            Log.w((String)TAG, (String)("mDevModel:  " + mDevModel));
            if (mDevModel.equalsIgnoreCase("500C")) {
                SSUtil.fiveType = "500C";
            } else if (mDevModel.equalsIgnoreCase("500CM")) {
                SSUtil.fiveType = "500CM";
            } else if (mDevModel.equalsIgnoreCase("500CH")) {
                SSUtil.fiveType = "500CH";
            } else if (mDevModel.equalsIgnoreCase("500CT")) {
                SSUtil.fiveType = "500CT";
            } else if (mDevModel.equalsIgnoreCase("JF106")) {
                SSUtil.fiveType = "700B";
            } else if (mDevModel.contains("700E")) {
                SSUtil.fiveType = "700E";
            } else if (mDevModel.contains("500BH")) {
                SSUtil.fiveType = "500BH";
            }
            Log.w((String)TAG, (String)("fp poweron path:" + path));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getmBaurd() {
        return this.mBaurd;
    }

    public void setmBaurd(int mBaurd) {
        this.mBaurd = mBaurd;
    }

    public int openCom() {
        if (this.mCom == null) {
            if (SSUtil.fiveType.equalsIgnoreCase("500C")) {
                this.mPath = "/dev/ttyMT0";
            } else if (SSUtil.fiveType.equals("500CM")) {
                this.mPath = "/dev/ttyMT0";
            } else if (SSUtil.fiveType.equalsIgnoreCase("500CH")) {
                this.mPath = "/dev/ttyMT2";
            } else if (SSUtil.fiveType.equalsIgnoreCase("500CT")) {
                this.mPath = "/dev/ttyHSL1";
            } else if (SSUtil.fiveType.equalsIgnoreCase("700B")) {
                this.mPath = "/dev/ttyS0";
            } else if (SSUtil.fiveType.equalsIgnoreCase("700E")) {
                this.mPath = "/dev/ttyS1";
            } else if (SSUtil.fiveType.equalsIgnoreCase("500BH")) {
                this.mPath = "/dev/ttyS1";
            }
            if (this.mPath.length() == 0 || this.mBaud == -1) {
                throw new InvalidParameterException();
            }
            try {
                Log.w((String)TAG, (String)("\u6253\u5f00\u8bfb\u5361\u4e32\u53e3" + this.mPath + "\u6ce2\u7279\u7387" + this.mBaud));
                this.mCom = new Serialport(new File(this.mPath), this.mBaud, 0);
            }
            catch (SecurityException e) {
                Log.w((String)TAG, (String)"\u4e32\u53e3\u6253\u5f00\u5f02\u5e38SecurityException");
                return -2;
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"\u4e32\u53e3\u6253\u5f00\u5f02\u5e38IOException");
                return -3;
            }
            this.powerOn();
            this.comOpenFlag = true;
        }
        return 1;
    }

    public int closeCom() {
        try {
            if (this.mCom != null) {
                Log.i((String)TAG, (String)("\u5173\u95ed\u4e32\u53e3\u7ed3\u679c=" + this.mCom.closeCom()));
                this.mCom = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"\u5173\u95ed\u4e32\u53e3\u53d1\u751f\u5f02\u5e38");
        }
        return 1;
    }

    private byte[] getBoardSoftVersion() {
        Log.i((String)TAG, (String)"getBoardSoftVersion()");
        byte[] dst = new byte[5];
        String dstStr = null;
        Arrays.fill(sendToCom, 0, 100, (byte)0);
        this.oneCommand(65303, sendToCom, 0, 16, 1, 100);
        if (sendToCom[7] == 0 && sendToCom[8] == 0 && sendToCom[9] == -112) {
            Log.i((String)TAG, (String)"\u6536\u5230\u5355\u7247\u673a\u5e94\u7b54");
            System.arraycopy(sendToCom, 10, dst, 0, 5);
            dstStr = new String(dst);
            Log.i((String)TAG, (String)("dstStr = " + dstStr));
        }
        Log.i((String)TAG, (String)("\u5355\u7247\u673a\u7248\u672c\u53f7:" + dstStr));
        return null;
    }

    public byte[] getId2CardId() {
        Log.w((String)TAG, (String)"getId2CardId()");
        byte[] dst = new byte[8];
        String dstStr = null;
        Arrays.fill(sendToCom, 0, 100, (byte)0);
        this.oneCommand(65313, sendToCom, 0, 20, 1, 100);
        if (sendToCom[7] == 0 && sendToCom[8] == 0 && sendToCom[9] == -112) {
            Log.w((String)TAG, (String)"\u6536\u5230\u5e94\u7b54--->getId2CardId");
            System.arraycopy(sendToCom, 10, dst, 0, 8);
            Log.w((String)TAG, (String)SSUtil.toHexStringWithSpace(sendToCom, 50));
            Log.w((String)TAG, (String)SSUtil.toHexStringWithSpace(dst, dst.length));
            return dst;
        }
        Log.w((String)TAG, (String)("\u5355\u7247\u673a\u7248\u672c\u53f7:" + dstStr));
        return null;
    }

    public byte[] getBoardHardwareVersion() {
        return null;
    }

    public String getSAMSN() {
        Log.i((String)TAG, (String)"getSAMSN()");
        byte[] temp = new byte[256];
        short[] PNO = new short[16];
        short head1 = 0;
        short head2 = 0;
        long data1 = 0L;
        long data2 = 0L;
        long data3 = 0L;
        String dstStr = null;
        readIDCardStatus back = this.oneCommand(4863, temp, 0, 27, 0, 200);
        if (readIDCardStatus.sdses_validateCRC_OK == back && temp[5] == 0 && temp[6] == 20 && temp[7] == 0 && temp[8] == 0 && temp[9] == -112) {
            int j = 0;
            while (j < 16) {
                PNO[j] = temp[10 + j] < 0 ? (short)(256 + temp[10 + j]) : (short)temp[10 + j];
                ++j;
            }
            head1 = (short)(PNO[1] * 256 + PNO[0]);
            head2 = (short)(PNO[3] * 256 + PNO[2]);
            data1 = (long)PNO[4] + (long)PNO[5] * 256L + (long)PNO[6] * 256L * 256L + (long)PNO[7] * 256L * 256L * 256L;
            data2 = (long)PNO[8] + (long)PNO[9] * 256L + (long)PNO[10] * 256L * 256L + (long)PNO[11] * 256L * 256L * 256L;
            data3 = (long)PNO[12] + (long)PNO[13] * 256L + (long)PNO[14] * 256L * 256L + (long)PNO[15] * 256L * 256L * 256L;
            Log.i((String)TAG, (String)String.format("%02d.%02d-%08d-%010d-%010d", head1, head2, data1, data2, data3));
            dstStr = String.format("%02d.%02d-%08d-%010d-%010d", head1, head2, data1, data2, data3);
            Log.i((String)TAG, (String)String.format("%1$08d%2$010d", data1, data2));
        }
        if (dstStr != null) {
            Log.i((String)TAG, (String)("SAM\u6a21\u5757\u53f7:" + dstStr));
        }
        return dstStr;
    }

    public boolean getSAMStatus() {
        Arrays.fill(sendToCom, 0, 100, (byte)0);
        readIDCardStatus back = this.oneCommand(4607, sendToCom, 0, 11, 0, 100);
        return readIDCardStatus.sdses_validateCRC_OK == back && sendToCom[7] == 0 && sendToCom[8] == 0 && sendToCom[9] == -112;
    }

    private boolean searchCard() {
        readIDCardStatus back = this.oneCommand(8193, sendToCom, 0, 15, 0, 200);
        return readIDCardStatus.sdses_validateCRC_OK == back && sendToCom[7] == 0 && sendToCom[8] == 0 && sendToCom[9] == -97;
    }

    private boolean selectCard() {
        Arrays.fill(sendToCom, 0, 256, (byte)0);
        readIDCardStatus back = this.oneCommand(8194, sendToCom, 0, 19, 0, 200);
        if (readIDCardStatus.sdses_validateCRC_OK == back && sendToCom[7] == 0 && sendToCom[8] == 0 && sendToCom[9] == -112) {
            Arrays.fill(IReadIDCard.mIDCardData, (byte)0);
            return true;
        }
        return false;
    }

    private boolean readCard() {
        Arrays.fill(sendToCom, (byte)0);
        readIDCardStatus back = this.oneCommand(12304, sendToCom, 0, 2321, 0, 1500);
        if (readIDCardStatus.sdses_validateCRC_OK == back && sendToCom[7] == 0 && sendToCom[8] == 0 && sendToCom[9] == -112) {
            System.arraycopy(sendToCom, 10, IReadIDCard.mIDCardData, 0, ((sendToCom[5] & 0xFF) << 8 | sendToCom[6] & 0xFF) - 4);
            return true;
        }
        return false;
    }

    private boolean readNewAddress() {
        int _len = 0;
        Arrays.fill(sendToCom, (byte)0);
        readIDCardStatus back = this.oneCommand(12291, sendToCom, 0, 81, 0, 150);
        if (readIDCardStatus.sdses_validateCRC_OK == back && sendToCom[7] == 0 && sendToCom[8] == 0 && sendToCom[9] == -112) {
            _len = ((sendToCom[5] & 0xFF) << 8 | sendToCom[6] & 0xFF) - 1;
            Log.i((String)TAG, (String)("_len=" + _len));
            System.arraycopy(sendToCom, 7, IReadIDCard.mIDCardData, 2310, _len);
            return true;
        }
        return false;
    }

    public void powerOn() {
        Log.i((String)TAG, (String)"powerOn all");
        try {
            String path = "";
            if (SSUtil.fiveType.equalsIgnoreCase("700B")) {
                Serialport.PowerOn();
            } else if (SSUtil.fiveType.equalsIgnoreCase("700E")) {
                GPIOControl.poweron();
            } else if (SSUtil.fiveType.equalsIgnoreCase("500BH")) {
                this.powerOn500BH();
            } else if (SSUtil.fiveType.equals("500CM")) {
                this.powerOn500CM();
            } else {
                if (SSUtil.fiveType.equalsIgnoreCase("500C")) {
                    path = "/proc/id_switch";
                } else if (SSUtil.fiveType.equalsIgnoreCase("500CH")) {
                    path = "/dev/sspm";
                } else if (SSUtil.fiveType.equalsIgnoreCase("500CT")) {
                    path = "/sys/devices/platform/finger2rfid/sspm";
                }
                FileWriter localFileWriterOn = new FileWriter(new File(path));
                localFileWriterOn.write("2");
                localFileWriterOn.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void powerOn500BH() {
        Log.i((String)TAG, (String)"powerOn all");
        LedcontrlActivity mIOCtrl = new LedcontrlActivity();
        if (mIOCtrl != null) {
            Log.i((String)TAG, (String)"GPIO On");
            mIOCtrl.HardInit();
            mIOCtrl.setIO(1, 1);
            mIOCtrl.HardRealse();
            mIOCtrl = null;
        }
    }

    private void powerOff500BH() {
        Log.i((String)TAG, (String)"powerOff end");
        LedcontrlActivity mIOCtrl = new LedcontrlActivity();
        if (mIOCtrl != null) {
            Log.i((String)TAG, (String)"mIOCtrl off");
            mIOCtrl.HardInit();
            mIOCtrl.setIO(1, 0);
            mIOCtrl.HardRealse();
            mIOCtrl = null;
        }
    }

    private void powerOn500CM() {
        SSUtil.writeSysfs("/sys/devices/virtual/misc/mtgpio/pin", "-w=25:0 0 1 1 1 1 0 ");
    }

    private void powerOff500CM() {
        SSUtil.writeSysfs("/sys/devices/virtual/misc/mtgpio/pin", "-w=25:0 0 0 1 1 1 0 ");
    }

    public void powerOff() {
        try {
            String path = "";
            if (SSUtil.fiveType.equalsIgnoreCase("700B")) {
                Serialport.PowerOff();
            } else if (SSUtil.fiveType.equalsIgnoreCase("700E")) {
                GPIOControl.poweroff();
            } else if (SSUtil.fiveType.equalsIgnoreCase("500BH")) {
                this.powerOff500BH();
            } else if (SSUtil.fiveType.equals("500CM")) {
                this.powerOff500CM();
            } else {
                if (SSUtil.fiveType.equalsIgnoreCase("500C")) {
                    path = "/proc/id_switch";
                } else if (SSUtil.fiveType.equalsIgnoreCase("500CH")) {
                    path = "/dev/sspm";
                } else if (SSUtil.fiveType.equalsIgnoreCase("500CT")) {
                    path = "/sys/devices/platform/finger2rfid/sspm";
                }
                FileWriter localFileWriterOn = new FileWriter(new File(path));
                localFileWriterOn.write("0");
                localFileWriterOn.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void f_powerOn500CM() {
        SSUtil.writeSysfs("/sys/devices/virtual/misc/mtgpio/pin", "-w=26:0 0 1 1 1 1 0 ");
        SSUtil.writeSysfs("/sys/devices/virtual/misc/mtgpio/pin", "-w=99:0 0 1 1 1 1 0 ");
    }

    private void f_powerOff500CM() {
        SSUtil.writeSysfs("/sys/devices/virtual/misc/mtgpio/pin", "-w=26:0 0 0 1 1 1 0 ");
        SSUtil.writeSysfs("/sys/devices/virtual/misc/mtgpio/pin", "-w=99:0 0 0 1 1 1 0 ");
    }

    public void f_powerOn() {
        try {
            String path = "";
            if (SSUtil.fiveType.equalsIgnoreCase("500CM")) {
                this.f_powerOn500CM();
            }
            if (SSUtil.fiveType.equalsIgnoreCase("500C")) {
                path = "/proc/id_switch";
            } else if (SSUtil.fiveType.equalsIgnoreCase("500CH")) {
                path = "/dev/sspm";
            } else if (SSUtil.fiveType.equalsIgnoreCase("500CT")) {
                path = "/dev/sspm";
            }
            FileWriter localFileWriterOn = new FileWriter(new File(path));
            localFileWriterOn.write("3");
            localFileWriterOn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void f_poweroff() {
        try {
            if (SSUtil.fiveType.equalsIgnoreCase("500CM")) {
                this.f_powerOff500CM();
            }
            String path = "";
            if (SSUtil.fiveType.equalsIgnoreCase("500C")) {
                path = "/proc/id_switch";
            } else if (SSUtil.fiveType.equalsIgnoreCase("500CH")) {
                path = "/dev/sspm";
            } else if (SSUtil.fiveType.equalsIgnoreCase("500CT")) {
                path = "/dev/sspm";
            }
            FileWriter localFileWriterOn = new FileWriter(new File(path));
            localFileWriterOn.write("1");
            localFileWriterOn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void f_usbOn() {
        int back = Serialport.USBPowerOn();
        Log.w((String)TAG, (String)("usb poweron= " + back));
    }

    public void f_usbOff() {
        int back = Serialport.USBPowerOff();
        Log.w((String)TAG, (String)("usb poweroff= " + back));
    }

    @Override
    public int readIDCardOpen() {
        this.mCardBoard.clearInfo();
        Log.e((String)TAG, (String)("\u6253\u5f00\u4e32\u53e3--------\u300b" + this.openCom()));
        if (1 != this.openCom()) {
            return 2;
        }
        this.powerOn();
        if (!this.initSAM()) {
            return 4;
        }
        String _samsn = this.getSAMSN();
        Log.e((String)TAG, (String)("sam sn--------------------" + _samsn));
        if (_samsn == null) {
            return 5;
        }
        this.mCardBoard.setSAMSN(_samsn);
        return 1;
    }

    public int readIDCardOpenNew() {
        if (1 != this.openCom()) {
            return 2;
        }
        this.powerOn();
        return 1;
    }

    private boolean initSAM() {
        int i = 0;
        while (i < 15) {
            if (this.getSAMStatus()) {
                return true;
            }
            SystemClock.sleep((long)100L);
            ++i;
        }
        return false;
    }

    public boolean localMode() {
        byte[] temp = new byte[256];
        readIDCardStatus back = this.oneCommand(65299, temp, 0, 19, 1, 200);
        if (readIDCardStatus.sdses_validateCRC_OK == back && temp[7] == 0 && temp[8] == 0 && temp[9] == -112) {
            Log.i((String)TAG, (String)"\u8bbe\u7f6e\u4e3b\u673a\u6a21\u5f0f\u6210\u529f");
            return true;
        }
        return false;
    }

    @Override
    public boolean readIDCard() {
        return this.readCard();
    }

    @Override
    public int readIDCardClose() {
        this.powerOff();
        int i = 0;
        while (i < 10) {
            if (!this.getSAMStatus()) break;
            ++i;
        }
        if (this.getSAMStatus()) {
            Log.i((String)TAG, (String)"\u6389\u7535\u5931\u8d25");
            this.closeCom();
            return 2;
        }
        Log.i((String)TAG, (String)"\u6389\u7535\u6210\u529f");
        this.closeCom();
        return 1;
    }

    @Override
    public int Command(int CMD, byte[] data, int sendLen, int recvLen, int nType, int wtime) {
        if (readIDCardStatus.sdses_validateCRC_OK == this.oneCommand(CMD, data, sendLen, recvLen, nType, wtime)) {
            return 1;
        }
        return 0;
    }

    public readIDCardStatus oneCommand(int CMD, byte[] data, int sendLen, int recvLen, int nType, int wtime) {
        if (this.mCom == null) {
            Log.i((String)TAG, (String)"mCom == null \u4e32\u53e3\u5df2\u7ecf\u5173\u95ed");
            return readIDCardStatus.readIDCard_Serialport_closeed;
        }
        int rlenInfact = 0;
        int i = 0;
        int memsetLen = sendLen > recvLen ? sendLen : recvLen;
        Arrays.fill(pbuffer, 0, memsetLen + 100, (byte)0);
        ReadCardFromSerialport.pbuffer[0] = -86;
        ReadCardFromSerialport.pbuffer[1] = -86;
        ReadCardFromSerialport.pbuffer[2] = -86;
        ReadCardFromSerialport.pbuffer[3] = -106;
        switch (nType) {
            case 0: {
                ReadCardFromSerialport.pbuffer[4] = 105;
                break;
            }
            case 1: {
                ReadCardFromSerialport.pbuffer[4] = 10;
                break;
            }
            case 2: {
                ReadCardFromSerialport.pbuffer[4] = 0;
                break;
            }
            default: {
                ReadCardFromSerialport.pbuffer[4] = -86;
            }
        }
        ReadCardFromSerialport.pbuffer[5] = (byte)((sendLen + 3) / 256);
        ReadCardFromSerialport.pbuffer[6] = (byte)((sendLen + 3) % 256);
        ReadCardFromSerialport.pbuffer[7] = (byte)(CMD >> 8 & 0xFF);
        ReadCardFromSerialport.pbuffer[8] = (byte)(CMD & 0xFF);
        if (data != null) {
            System.arraycopy(data, 0, pbuffer, 9, sendLen);
        }
        i = 0;
        while (i < sendLen + 4) {
            int n = 9 + sendLen;
            pbuffer[n] = (byte)(pbuffer[n] ^ pbuffer[5 + i]);
            ++i;
        }
        Log.i((String)TAG, (String)("oneCommand\u5b9e\u9645\u53d1\u9001\u7684\u6570\u636e" + SSUtil.toHexStringWithSpace(pbuffer, sendLen + 10)));
        Log.i((String)TAG, (String)("oneCommand\u53d1\u9001\u6570\u636e\u957f\u5ea6=" + (sendLen + 10)));
        rlenInfact = this.mCom.oneCommand(pbuffer, sendLen + 10, recvLen, wtime);
        Log.i((String)TAG, (String)("\u5b9e\u9645\u6536\u5230\u7684\u5b57\u8282\u6570=" + rlenInfact));
        Log.i((String)TAG, (String)("oneCommand\u5b9e\u9645\u63a5\u6536\u5230\u7684\u6570\u636e" + SSUtil.toHexStringWithSpace(pbuffer, rlenInfact)));
        if (rlenInfact > 0) {
            readIDCardStatus back = this.recvDataCheck(pbuffer, rlenInfact);
            if (readIDCardStatus.sdses_validateCRC_OK == back) {
                Arrays.fill(data, (byte)0);
                System.arraycopy(pbuffer, 0, data, 0, rlenInfact);
            }
            return back;
        }
        return readIDCardStatus.sdses_data_null;
    }

    private readIDCardStatus recvDataCheck(byte[] recvBuff, int rlenInfact) {
        if (recvBuff[0] != -86 && recvBuff[1] != -86 && recvBuff[2] != -86 && recvBuff[3] != -106) {
            recvBuff = null;
            return readIDCardStatus.sdses_protocolheader_Err;
        }
        if (recvBuff[4] != 105 && recvBuff[4] != 10) {
            recvBuff = null;
            return readIDCardStatus.sdses_protocolheader_Err;
        }
        int nLength = (recvBuff[5] & 0xFF) << 8 | recvBuff[6] & 0xFF;
        if (rlenInfact != 7 + nLength) {
            return readIDCardStatus.sdses_datalenth_Err;
        }
        byte byParity = 0;
        int i = 0;
        while (i < rlenInfact - 6) {
            byParity = (byte)(byParity ^ recvBuff[5 + i]);
            ++i;
        }
        if (recvBuff[rlenInfact - 1] == byParity) {
            return readIDCardStatus.sdses_validateCRC_OK;
        }
        return readIDCardStatus.sdses_validateCRC_Err;
    }

    @Override
    public boolean searchIDCard() {
        return this.searchCard();
    }

    @Override
    public boolean selectIDCard() {
        return this.selectCard();
    }

    @Override
    public boolean readID2NewAddress() {
        return this.readNewAddress();
    }

    @Override
    public CardBoard getCardBoardInfo() {
        return this.mCardBoard;
    }

    @Override
    public int Command100X1(int CMD, int address, byte[] data, int sendLen, int recvLen, int backInfact, int wtime) {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public serviceEnum oneCommand100X1(int CMD, int address, byte[] data, int sendLen, int recvLen, int backInfact, int wtime) {
        int curentWriteBufLen = 0;
        int memsetLen = sendLen > recvLen ? sendLen : recvLen;
        SSUtil.memset(pbuffer, 0, memsetLen + 100);
        ReadCardFromSerialport.pbuffer[0] = 83;
        ReadCardFromSerialport.pbuffer[1] = 68;
        ReadCardFromSerialport.pbuffer[2] = 115;
        ReadCardFromSerialport.pbuffer[3] = 69;
        ReadCardFromSerialport.pbuffer[4] = 115;
        ReadCardFromSerialport.pbuffer[5] = 0;
        curentWriteBufLen = 6;
        ReadCardFromSerialport.pbuffer[6] = (byte)((2 + sendLen + 2) / 256 / 256 / 256);
        ReadCardFromSerialport.pbuffer[7] = (byte)((2 + sendLen + 2) / 256 / 256 % 256);
        ReadCardFromSerialport.pbuffer[8] = (byte)((2 + sendLen + 2) / 256 % 256);
        ReadCardFromSerialport.pbuffer[9] = (byte)((2 + sendLen + 2) % 256);
        curentWriteBufLen += 4;
        ReadCardFromSerialport.pbuffer[10] = (byte)(CMD >> 8 & 0xFF);
        ReadCardFromSerialport.pbuffer[11] = (byte)(CMD & 0xFF);
        curentWriteBufLen += 2;
        if (sendLen > 0) {
            System.arraycopy(data, 0, pbuffer, 12, sendLen);
            curentWriteBufLen += sendLen;
        }
        byte[] crc16buffer = new byte[6 + sendLen];
        System.arraycopy(pbuffer, 6, crc16buffer, 0, 6 + sendLen);
        byte[] bytecrc16 = CRC16CCITT.calcCRC(crc16buffer);
        System.arraycopy(bytecrc16, 0, pbuffer, curentWriteBufLen, 2);
        int rlenInfact = this.mCom.oneCommand100X1(pbuffer, curentWriteBufLen += 2, recvLen, wtime);
        Log.w((String)TAG, (String)("\u5b9e\u9645\u6536\u5230\u7684\u5b57\u8282\u6570=" + rlenInfact));
        if (rlenInfact <= 0) return serviceEnum.sdses_data_null;
        String temp = "";
        serviceEnum back = this.recvDataCheck100X1(pbuffer, rlenInfact);
        if (serviceEnum.sdses_validateCRC_OK != back) return back;
        if ((pbuffer[12] & 0xFF) != 144) {
            back = serviceEnum.sdses_stateCode_Err;
            Log.w((String)TAG, (String)String.format("CMD %X \u8fd4\u56de\u503c\u6821\u9a8c\u7801\u4e0d\u6b63\u786e", CMD));
            return back;
        }
        backInfact = rlenInfact;
        Arrays.fill(data, (byte)0);
        System.arraycopy(pbuffer, 0, data, 0, rlenInfact);
        return back;
    }

    private serviceEnum recvDataCheck100X1(byte[] recvBuff, int rlenInfact) {
        if (recvBuff[0] != 83 && recvBuff[1] != 68 && recvBuff[2] != 115 && recvBuff[3] != 69 && recvBuff[4] != 115) {
            recvBuff = null;
            return serviceEnum.sdses_protocolheader_Err;
        }
        long nLen = (recvBuff[6] & 0xFF) * 256 * 256 * 256 + (recvBuff[7] & 0xFF) * 256 * 256 + (recvBuff[8] & 0xFF) * 256 + (recvBuff[9] & 0xFF);
        if ((long)rlenInfact != 10L + nLen) {
            Log.w((String)TAG, (String)("\u63a5\u6536\u5230\u6570\u636e\u957f\u5ea6\u4e0d\u6b63\u786e " + rlenInfact));
            recvBuff = null;
            return serviceEnum.sdses_datalenth_Err;
        }
        byte[] crc16buffer = new byte[(int)(4L + nLen - 2L)];
        System.arraycopy(recvBuff, 6, crc16buffer, 0, (int)(4L + nLen - 2L));
        byte[] bytecrc16 = CRC16CCITT.calcCRC(crc16buffer);
        if (bytecrc16[0] == recvBuff[(int)(10L + nLen - 2L)] && bytecrc16[1] == recvBuff[(int)(10L + nLen - 1L)]) {
            Log.w((String)TAG, (String)("\u8fd4\u56de\u6821\u9a8c\u6b63\u786e " + rlenInfact));
            return serviceEnum.sdses_validateCRC_OK;
        }
        Log.w((String)TAG, (String)("\u8fd4\u56de\u6821\u9a8c\u9519\u8bef" + rlenInfact));
        return serviceEnum.sdses_validateCRC_Err;
    }
}

