/*
 * Decompiled with CFR 0.152.
 */
package com.sdses.crc;

public class FormatTransfer {
    public static byte[] toLH(int n) {
        byte[] b = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return b;
    }

    public static byte[] toHH(int n) {
        byte[] b = new byte[4];
        b[3] = (byte)(n & 0xFF);
        b[2] = (byte)(n >> 8 & 0xFF);
        b[1] = (byte)(n >> 16 & 0xFF);
        b[0] = (byte)(n >> 24 & 0xFF);
        return b;
    }

    public static byte[] toLH(short n) {
        byte[] b = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return b;
    }

    public static byte[] toHH(short n) {
        byte[] b = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return b;
    }

    public static byte[] toLH(float f) {
        return FormatTransfer.toLH(Float.floatToRawIntBits(f));
    }

    public static byte[] toHH(float f) {
        return FormatTransfer.toHH(Float.floatToRawIntBits(f));
    }

    public static byte[] stringToBytes(String s, int length) {
        while (s.getBytes().length < length) {
            s = String.valueOf(s) + " ";
        }
        return s.getBytes();
    }

    public static String bytesToString(byte[] b) {
        StringBuffer result = new StringBuffer("");
        int length = b.length;
        int i = 0;
        while (i < length) {
            result.append((char)(b[i] & 0xFF));
            ++i;
        }
        return result.toString();
    }

    public static byte[] stringToBytes(String s) {
        return s.getBytes();
    }

    public static int hBytesToInt(byte[] b) {
        int s = 0;
        int i = 0;
        while (i < 3) {
            s = b[i] >= 0 ? (s += b[i]) : s + 256 + b[i];
            s *= 256;
            ++i;
        }
        s = b[3] >= 0 ? (s += b[3]) : s + 256 + b[3];
        return s;
    }

    public static int lBytesToInt(byte[] b) {
        int s = 0;
        int i = 0;
        while (i < 3) {
            s = b[3 - i] >= 0 ? (s += b[3 - i]) : s + 256 + b[3 - i];
            s *= 256;
            ++i;
        }
        s = b[0] >= 0 ? (s += b[0]) : s + 256 + b[0];
        return s;
    }

    public static short hBytesToShort(byte[] b) {
        int s = 0;
        s = b[0] >= 0 ? (s += b[0]) : s + 256 + b[0];
        s *= 256;
        s = b[1] >= 0 ? (s += b[1]) : s + 256 + b[1];
        short result = (short)s;
        return result;
    }

    public static short lBytesToShort(byte[] b) {
        int s = 0;
        s = b[1] >= 0 ? (s += b[1]) : s + 256 + b[1];
        s *= 256;
        s = b[0] >= 0 ? (s += b[0]) : s + 256 + b[0];
        short result = (short)s;
        return result;
    }

    public static float hBytesToFloat(byte[] b) {
        int i = 0;
        Float F = new Float(0.0);
        i = (((b[0] & 0xFF) << 8 | b[1] & 0xFF) << 8 | b[2] & 0xFF) << 8 | b[3] & 0xFF;
        return Float.intBitsToFloat(i);
    }

    public static float lBytesToFloat(byte[] b) {
        int i = 0;
        Float F = new Float(0.0);
        i = (((b[3] & 0xFF) << 8 | b[2] & 0xFF) << 8 | b[1] & 0xFF) << 8 | b[0] & 0xFF;
        return Float.intBitsToFloat(i);
    }

    public static byte[] bytesReverseOrder(byte[] b) {
        int length = b.length;
        byte[] result = new byte[length];
        int i = 0;
        while (i < length) {
            result[length - i - 1] = b[i];
            ++i;
        }
        return result;
    }

    public static void printBytes(byte[] bb) {
        int length = bb.length;
        int i = 0;
        while (i < length) {
            System.out.print(bb + " ");
            ++i;
        }
        System.out.println("");
    }

    public static void logBytes(byte[] bb) {
        int length = bb.length;
        String out = "";
        int i = 0;
        while (i < length) {
            out = String.valueOf(out) + bb + " ";
            ++i;
        }
    }

    public static int reverseInt(int i) {
        int result = FormatTransfer.hBytesToInt(FormatTransfer.toLH(i));
        return result;
    }

    public static short reverseShort(short s) {
        short result = FormatTransfer.hBytesToShort(FormatTransfer.toLH(s));
        return result;
    }

    public static float reverseFloat(float f) {
        float result = FormatTransfer.hBytesToFloat(FormatTransfer.toLH(f));
        return result;
    }

    public static boolean hexStrToBytes(String hexStr, byte[] bb, int nLength) {
        String[] hexstrs = null;
        hexstrs = hexStr.split(" ");
        if (hexstrs.length == nLength) {
            int i = 0;
            while (i < hexstrs.length) {
                byte b;
                bb[i] = b = (byte)Integer.parseInt(hexstrs[i], 16);
                ++i;
            }
            return true;
        }
        return false;
    }

    public static byte hexStrTo1Byte(String hexstr) {
        byte b = (byte)Integer.parseInt(hexstr, 16);
        return b;
    }
}

