/*
 * Decompiled with CFR 0.152.
 */
package com.sdses.fingerJar;

import android.content.Context;
import android.hardware.usb.UsbDeviceConnection;
import android.os.Environment;
import android.util.Log;
import com.techshino.fingerprint.FPConfig;
import com.techshino.fingerprint.FingerprintJni;
import com.techshino.fingerprint.tesoutil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class SsFinger {
    public static final String TAG = "SsFinger";
    public static final int imageWidth = 256;
    public static final int imageHeight = 360;
    public static final int imageSize = 93238;
    public FingerprintJni finger;
    byte[] feature = new byte[512];
    byte[] rawData = new byte[92160];
    int GAScore = 0;

    public int init(UsbDeviceConnection usbConnection, Context mContext) {
        if (usbConnection != null) {
            int result;
            this.finger = new FingerprintJni(mContext);
            int fd = usbConnection.getFileDescriptor();
            FPConfig.setFeatureType(5);
            FPConfig.setFingerCode(11);
            FPConfig.setImageType(0);
            FPConfig.setScannerType(0);
            String path = String.valueOf(Environment.getExternalStorageDirectory().toString()) + "/flog";
            File file = new File(path);
            if (!file.exists()) {
                file.mkdir();
            }
            if ((result = this.finger.LIVESCAN_Init(fd, path)) == 1) {
                Log.e((String)TAG, (String)"Init success !!!");
                return 0;
            }
            Log.e((String)TAG, (String)"Init fail !!!");
            return result;
        }
        Log.e((String)TAG, (String)"usbConnection == null");
        return -1;
    }

    public int close() {
        return this.finger.LIVESCAN_Close();
    }

    public byte[] getFingerByteData(int fingerNum, int ScannerType) {
        byte[] tempFeature = new byte[513];
        int[] ImageAttr = new int[3];
        byte[] imageBuffer = new byte[93238];
        byte[] TESOimageBuffer = new byte[251078];
        FPConfig.setFingerCode(fingerNum);
        FPConfig.setScannerType(ScannerType);
        this.finger.FP_FeatureAndImageExtract(tempFeature, imageBuffer, TESOimageBuffer, ImageAttr);
        this.GAScore = this.finger.FP_GAGetQualityScore(imageBuffer);
        System.arraycopy(tempFeature, 0, this.feature, 0, 512);
        System.arraycopy(TESOimageBuffer, 0, this.rawData, 0, 92160);
        tesoutil.saveFile(this.rawData, "raw");
        return imageBuffer;
    }

    public byte[] getFingerBmpByteData(int nChannel) {
        byte[] imageBuffer = new byte[93238];
        this.finger.LIVESCAN_GetFPBmpData(nChannel, imageBuffer);
        return imageBuffer;
    }

    public byte[] getFingerRawByteData(int nChannel) {
        Arrays.fill(this.rawData, (byte)0);
        byte[] pRawData = new byte[92160];
        this.finger.LIVESCAN_GetFPRawData(nChannel, pRawData);
        System.arraycopy(pRawData, 0, this.rawData, 0, 92160);
        return pRawData;
    }

    public int getFingerQuality() {
        return this.GAScore;
    }

    public String getFingerInfoQuick(int whichBuffer, byte[] imgByte) {
        return SsFinger.bytesToHexString(this.feature);
    }

    public String getFingerInfoQuick(int whichBuffer) {
        return SsFinger.bytesToHexString(this.feature);
    }

    public int ReInitFPCSensor() {
        if (this.finger != null) {
            this.finger.FP_ReInitFPCSensor();
            return 0;
        }
        return -1;
    }

    public int fingerComparison(String fingerInfo1, String fingerInfo2) {
        byte[] featureData1 = SsFinger.hexStringToByte(fingerInfo1);
        byte[] featureTemplet = SsFinger.hexStringToByte(fingerInfo2);
        float score = this.finger.FP_FeatureMatch(featureData1, featureTemplet);
        return (int)score;
    }

    public String getDeviceInfo() {
        try {
            byte[] Versionbuffer = new byte[64];
            this.finger.FP_GetVersion(Versionbuffer);
            String VersionString = new String(Versionbuffer, "ISO-8859-1");
            return VersionString;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] hexStringToByte(String hex) {
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        int i = 0;
        while (i < len) {
            int pos = i * 2;
            result[i] = (byte)(SsFinger.toByte(achar[pos]) << 4 | SsFinger.toByte(achar[pos + 1]));
            ++i;
        }
        return result;
    }

    private static int toByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }

    public static final String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        int i = 0;
        while (i < bArray.length) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
            ++i;
        }
        return sb.toString();
    }
}

