/*
 * Decompiled with CFR 0.152.
 */
package com.sdses.service;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.IBinder;
import android.os.SystemClock;
import android.util.Log;
import com.sdses.bean.ID2Data;
import com.sdses.common.CardBoard;
import com.sdses.manage.ManageReadIDCard;
import java.io.Serializable;

public class ReadID2Card
extends Service {
    public static final String TAG = ReadID2Card.class.getSimpleName();
    boolean bIOControl = false;
    boolean bExit = false;
    int iWaitTimes = 100;
    ReadID2CardReceiver mReadID2CardReceiver = null;
    ManageReadIDCard mManageReadIDCard;
    Thread readID2CardThread;

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        this.mReadID2CardReceiver = new ReadID2CardReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("com.sdses.ReadID2CardService");
        this.registerReceiver(this.mReadID2CardReceiver, filter);
        this.mManageReadIDCard = new ManageReadIDCard();
        this.mManageReadIDCard.getID2DataController("com.sdses.bean.ID2Data");
        this.mManageReadIDCard.getID2CardReader("com.sdses.common.impl.ReadCardFromSerialport");
    }

    public void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.mReadID2CardReceiver);
        Log.i((String)TAG, (String)"\u670d\u52a1\u53d6\u6d88");
    }

    private boolean openRFtoTypeB() {
        byte[] temp = new byte[256];
        int back = this.mManageReadIDCard.Command(65295, temp, 0, 11, 1, 200);
        if (1 == back && temp[7] == 0 && temp[8] == 0 && temp[9] == -112) {
            Log.w((String)TAG, (String)"\u8bbe\u7f6eTypeB\u6a21\u5f0f\u6210\u529f");
            return true;
        }
        return false;
    }

    private boolean closeRF() {
        byte[] temp = new byte[256];
        int back = this.mManageReadIDCard.Command(65296, temp, 0, 11, 1, 200);
        if (1 == back && temp[7] == 0 && temp[8] == 0 && temp[9] == -112) {
            Log.w((String)TAG, (String)"\u5173\u5c04\u9891\u6210\u529f");
            return true;
        }
        return false;
    }

    private class ReadCardThread
    implements Runnable {
        int count = 0;

        private ReadCardThread() {
        }

        @Override
        public void run() {
            Log.w((String)TAG, (String)"in Thread ReadCardThread()");
            int b = ReadID2Card.this.mManageReadIDCard.readID2CardOpen();
            switch (b) {
                case 1: {
                    CardBoard _cardBoard = ReadID2Card.this.mManageReadIDCard.getCardBoardInfo();
                    Log.i((String)TAG, (String)("\u786c\u4ef6\u7248\u672c" + _cardBoard.getCardBoardHardwareVersion()));
                    Log.i((String)TAG, (String)("\u8f6f\u4ef6\u7248\u672c" + _cardBoard.getCardBoardSoftVersion()));
                    Log.i((String)TAG, (String)("SAM\u6a21\u5757\u53f7" + _cardBoard.getSAMSN()));
                    Log.i((String)TAG, (String)("\u8bfb\u5361\u677f\u5e8f\u53f7" + _cardBoard.getCardBoardSN()));
                    ReadID2Card.this.sendBroadcast(new Intent().setAction("com.sdses.activity").putExtra("command", 10));
                    break;
                }
                case 2: {
                    ReadID2Card.this.sendBroadcast(new Intent().setAction("com.sdses.activity").putExtra("command", 4));
                    b = ReadID2Card.this.mManageReadIDCard.readID2CardClose();
                    Log.i((String)TAG, (String)("\u5173\u95ed\u8bfb\u5361=" + b));
                    return;
                }
                case 3: {
                    ReadID2Card.this.sendBroadcast(new Intent().setAction("com.sdses.activity").putExtra("command", 5));
                    b = ReadID2Card.this.mManageReadIDCard.readID2CardClose();
                    Log.i((String)TAG, (String)("\u4e0a\u7535\u5931\u8d25=" + b));
                    return;
                }
                case 4: {
                    ReadID2Card.this.sendBroadcast(new Intent().setAction("com.sdses.activity").putExtra("command", 6));
                    b = ReadID2Card.this.mManageReadIDCard.readID2CardClose();
                    Log.i((String)TAG, (String)("\u521d\u59cb\u5316SAM\u6a21\u5757\u5931\u8d25=" + b));
                    return;
                }
                case 5: {
                    ReadID2Card.this.sendBroadcast(new Intent().setAction("com.sdses.activity").putExtra("command", 7));
                    b = ReadID2Card.this.mManageReadIDCard.readID2CardClose();
                    Log.i((String)TAG, (String)("\u83b7\u53d6SAM\u6a21\u5757\u53f7\u5931\u8d25=" + b));
                    return;
                }
            }
            Log.i((String)TAG, (String)("\u8bfb\u5361\u65f6\u95f4\u95f4\u9694=" + ReadID2Card.this.iWaitTimes));
            while (!ReadID2Card.this.bExit) {
                if (ReadID2Card.this.bIOControl) {
                    ReadID2Card.this.openRFtoTypeB();
                }
                if (ReadID2Card.this.mManageReadIDCard.searchID2Card() && ReadID2Card.this.mManageReadIDCard.selectID2Card()) {
                    ReadID2Card.this.sendBroadcast(new Intent().setAction("com.sdses.activity").putExtra("command", 2));
                    if (ReadID2Card.this.mManageReadIDCard.readID2Card()) {
                        Log.e((String)TAG, (String)("\u8bfb\u5361\u6210\u529f=" + this.count++));
                        ((ID2Data)ReadID2Card.this.mManageReadIDCard.getmID2DataRAW()).rePackage();
                        ReadID2Card.this.sendBroadcast(new Intent().setAction("com.sdses.activity").putExtra("command", 1).putExtra("id2data", (Serializable)((ID2Data)ReadID2Card.this.mManageReadIDCard.getmID2DataRAW())));
                    } else {
                        Log.i((String)TAG, (String)"\u8bfb\u5361\u5f02\u5e38 \u8bfb\u5361\u4e32\u53e3\u53d1\u751f\u6570\u636e\u6536\u53d1\u5f02\u5e38");
                        ReadID2Card.this.sendBroadcast(new Intent().setAction("com.sdses.activity").putExtra("command", 3));
                    }
                }
                if (ReadID2Card.this.bIOControl) {
                    ReadID2Card.this.closeRF();
                }
                SystemClock.sleep((long)ReadID2Card.this.iWaitTimes);
            }
            b = ReadID2Card.this.mManageReadIDCard.readID2CardClose();
            Log.i((String)TAG, (String)("\u5173\u95ed\u8bfb\u5361=" + b));
            switch (b) {
                case 1: {
                    ReadID2Card.this.sendBroadcast(new Intent().setAction("com.sdses.activity").putExtra("command", 8));
                    break;
                }
                case 2: {
                    ReadID2Card.this.sendBroadcast(new Intent().setAction("com.sdses.activity").putExtra("command", 9));
                    break;
                }
                default: {
                    ReadID2Card.this.sendBroadcast(new Intent().setAction("com.sdses.activity").putExtra("command", 11));
                }
            }
            Log.w((String)TAG, (String)"\u8bfb\u5361\u7ebf\u7a0b\u9000\u51fa");
        }
    }

    private class ReadID2CardReceiver
    extends BroadcastReceiver {
        private ReadID2CardReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.sdses.ReadID2CardService")) {
                Bundle bundle = intent.getExtras();
                int cmd = bundle.getInt("command");
                switch (cmd) {
                    case 1: {
                        Log.w((String)TAG, (String)"\u53c2\u6570\u8bbe\u7f6e");
                        ReadID2Card.this.bIOControl = bundle.getBoolean("GPIO");
                        ReadID2Card.this.iWaitTimes = bundle.getInt("Waittime");
                        Log.i((String)TAG, (String)("bIOControl=" + ReadID2Card.this.bIOControl));
                        Log.i((String)TAG, (String)("iWaitTimes=" + ReadID2Card.this.iWaitTimes));
                        break;
                    }
                    case 2: {
                        ReadID2Card.this.bExit = false;
                        ReadID2Card.this.readID2CardThread = new Thread(new ReadCardThread());
                        ReadID2Card.this.readID2CardThread.start();
                        Log.i((String)TAG, (String)("readID2CardThread.id=" + ReadID2Card.this.readID2CardThread.getId()));
                        break;
                    }
                    case 3: {
                        if (!ReadID2Card.this.bExit) {
                            ReadID2Card.this.bExit = true;
                        } else {
                            int b = ReadID2Card.this.mManageReadIDCard.readID2CardClose();
                            Log.i((String)TAG, (String)("\u5173\u95ed\u8bfb\u5361\u7ebf\u7a0bID=" + b));
                            switch (b) {
                                case 1: {
                                    ReadID2Card.this.sendBroadcast(new Intent().setAction("com.sdses.activity").putExtra("command", 8));
                                    break;
                                }
                                case 2: {
                                    ReadID2Card.this.sendBroadcast(new Intent().setAction("com.sdses.activity").putExtra("command", 9));
                                    break;
                                }
                                default: {
                                    ReadID2Card.this.sendBroadcast(new Intent().setAction("com.sdses.activity").putExtra("command", 11));
                                }
                            }
                        }
                        if (ReadID2Card.this.readID2CardThread == null) break;
                        Log.i((String)TAG, (String)("\u5173\u95ed\u8bfb\u5361= " + ReadID2Card.this.readID2CardThread.getId()));
                        break;
                    }
                }
            }
        }
    }
}

