/*
 * Decompiled with CFR 0.152.
 */
package com.sdses;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;

public class BlueTooth {
    private static UUID SS_UUID = UUID.fromString("00001101-0000-1000-8000-00805F9B34FB");
    private static BluetoothAdapter mAdapter = null;
    private static BluetoothDevice mDevice = null;
    private static BluetoothSocket mSocket = null;
    private static InputStream mInputStream = null;
    private static OutputStream mOutputStream = null;

    public static long BthConnect(String BlueToothName) {
        mAdapter = BluetoothAdapter.getDefaultAdapter();
        if (mAdapter == null) {
            return -1L;
        }
        if (!mAdapter.isEnabled()) {
            return -2L;
        }
        Set pairedDevices = mAdapter.getBondedDevices();
        if (pairedDevices.size() <= 0) {
            return -3L;
        }
        ArrayList<BluetoothDevice> ALBluetoothDevice = new ArrayList<BluetoothDevice>();
        for (BluetoothDevice device : pairedDevices) {
            ALBluetoothDevice.add(device);
        }
        int i = 0;
        while (i < ALBluetoothDevice.size()) {
            BluetoothDevice cDevice = (BluetoothDevice)ALBluetoothDevice.get(i);
            String theBlueToothName = cDevice.getName();
            if (theBlueToothName.indexOf(BlueToothName) >= 0) {
                mDevice = cDevice;
                try {
                    mSocket = mDevice.createRfcommSocketToServiceRecord(SS_UUID);
                    mSocket.connect();
                    mInputStream = mSocket.getInputStream();
                    mOutputStream = mSocket.getOutputStream();
                    return 0L;
                }
                catch (Exception e) {
                    return -4L;
                }
            }
            ++i;
        }
        return -5L;
    }

    public static long BthSendSocket(byte[] buffer, int len) {
        if (mOutputStream == null) {
            return -1L;
        }
        try {
            mOutputStream.write(buffer, 0, len);
        }
        catch (IOException e) {
            return -2L;
        }
        return len;
    }

    public static long BthRecvSocket(byte[] buffer) {
        if (mInputStream == null) {
            return -1L;
        }
        try {
            return mInputStream.read(buffer, 0, 4096);
        }
        catch (IOException e) {
            return -2L;
        }
    }

    public static void BthDisconnect() {
        if (mInputStream != null) {
            try {
                mInputStream.close();
                mInputStream = null;
            }
            catch (IOException e) {
                return;
            }
        }
        if (mOutputStream != null) {
            try {
                mOutputStream.close();
                mOutputStream = null;
            }
            catch (IOException e) {
                return;
            }
        }
        if (mSocket != null) {
            try {
                mSocket.close();
                mSocket = null;
            }
            catch (IOException e) {
                return;
            }
        }
    }
}

