/*
 * Decompiled with CFR 0.152.
 */
package com.sdses;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import java.util.HashMap;

public class UsbHidPort {
    private static final String ACTION_USB_PERMISSION = "com.sdses.JniCommonInterface.USB_PERMISSION";
    private static final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals(UsbHidPort.ACTION_USB_PERMISSION)) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false)) {
                        // empty if block
                    }
                }
            }
        }
    };
    public static UsbManager usbManager = null;
    public static UsbDevice usbDevice = null;
    public static UsbInterface usbInterface = null;
    public static UsbDeviceConnection usbConnection = null;
    public static UsbEndpoint epOut;
    public static UsbEndpoint epIn;
    public static int SendBlockSize;
    public static int RecvBlockSize;

    static {
        SendBlockSize = 0;
        RecvBlockSize = 0;
    }

    public static synchronized long GetUsbPermission(Context ctx, int Vid, int Pid) {
        usbManager = (UsbManager)ctx.getSystemService("usb");
        HashMap deviceList = usbManager.getDeviceList();
        for (UsbDevice device : deviceList.values()) {
            if (device.getVendorId() != Vid || device.getProductId() != Pid) continue;
            usbDevice = device;
            break;
        }
        if (usbDevice == null) {
            return -1L;
        }
        if (usbDevice.getInterfaceCount() <= 0) {
            return -2L;
        }
        usbInterface = usbDevice.getInterface(0);
        if (!usbManager.hasPermission(usbDevice)) {
            PendingIntent mPermissionIntent = PendingIntent.getBroadcast((Context)ctx, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
            IntentFilter permissionFilter = new IntentFilter(ACTION_USB_PERMISSION);
            ctx.registerReceiver(mUsbReceiver, permissionFilter);
            usbManager.requestPermission(usbDevice, mPermissionIntent);
            System.out.print("Requesting Usb Permission");
            while (!usbManager.hasPermission(usbDevice)) {
            }
        }
        return 0L;
    }

    public static long UsbOpenPort(int Vid, int Pid) {
        usbConnection = usbManager.openDevice(usbDevice);
        if (usbConnection == null) {
            return -1L;
        }
        if (!usbConnection.claimInterface(usbInterface, true)) {
            usbConnection.close();
            usbConnection = null;
            return -2L;
        }
        int i = 0;
        while (i < usbInterface.getEndpointCount()) {
            UsbEndpoint endPoint = usbInterface.getEndpoint(i);
            switch (endPoint.getType()) {
                case 3: {
                    switch (endPoint.getDirection()) {
                        case 0: {
                            epOut = endPoint;
                            break;
                        }
                        case 128: {
                            epIn = endPoint;
                        }
                    }
                    break;
                }
                case 0: {
                    epOut = endPoint;
                    epIn = endPoint;
                }
            }
            ++i;
        }
        SendBlockSize = epOut.getMaxPacketSize();
        RecvBlockSize = epIn.getMaxPacketSize();
        return SendBlockSize;
    }

    public static long UsbWrite(byte[] buffer, int len, int timeout) {
        return usbConnection.bulkTransfer(epOut, buffer, SendBlockSize, timeout);
    }

    public static long UsbRead(byte[] buffer, int timeout) {
        return usbConnection.bulkTransfer(epIn, buffer, RecvBlockSize, timeout);
    }

    public static long UsbCtrlWrite(byte[] buffer, int len, int timeout) {
        return usbConnection.controlTransfer(33, 9, 512, 0, buffer, SendBlockSize, timeout);
    }

    public static long UsbCtrlRead(byte[] buffer, int timeout) {
        return usbConnection.controlTransfer(161, 1, 256, 0, buffer, RecvBlockSize, timeout);
    }

    public static void UsbClosePort() {
        usbConnection.releaseInterface(usbInterface);
        usbConnection.close();
    }
}

