/*
 * Decompiled with CFR 0.152.
 */
package com.sdses.serialport;

import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;

public class Serialport {
    private static final String TAG = "SerialPort";
    private FileDescriptor mFd;

    static {
        try {
            System.loadLibrary("SDSES_SerialPort_1.1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Serialport(File device, int baudrate, int flags) throws SecurityException, IOException {
        if (!device.canRead() || !device.canWrite()) {
            try {
                Process su = null;
                String cmd = "chmod 777 " + device.getAbsolutePath() + "\n" + "exit\n";
                Log.w((String)TAG, (String)"");
                su = Runtime.getRuntime().exec("/system/xbin/su");
                su.getOutputStream().write(cmd.getBytes());
                if (su.waitFor() != 0 || !device.canRead() || !device.canWrite()) {
                    Log.w((String)TAG, (String)"\u6d93\u63d2\u5f5b\u7481\u60e7\ue62c\u6d60\u5d87\u52a7\u6d93\u5d85\u5f72\u7487\u8bf2\u5553");
                    throw new SecurityException();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.w((String)TAG, (String)("\u5bee\u509a\u7236\u6dc7\u2103\u4f05:" + e));
                throw new SecurityException();
            }
        }
        this.mFd = Serialport.openCom(device.getAbsolutePath(), baudrate, flags);
        if (this.mFd == null) {
            throw new IOException();
        }
    }

    public static native int PowerOn();

    public static native int PowerOff();

    public static native int FPPowerOn();

    public static native int FPPowerOff();

    public static native int USBPowerOn();

    public static native int USBPowerOff();

    private static native FileDescriptor openCom(String var0, int var1, int var2);

    public native int closeCom();

    public native int oneCommand(byte[] var1, int var2, int var3, int var4);

    public native int GetPowerInfo(int var1);

    public native int oneCommand100X1(byte[] var1, int var2, int var3, int var4);
}

